/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources;

import cn.com.yusys.yusp.bsp.resources.ResourceCreator;
import cn.com.yusys.yusp.bsp.resources.ResourceException;
import cn.com.yusys.yusp.bsp.resources.bean.SpringContextRegistry;
import cn.com.yusys.yusp.bsp.resources.core.ResourceHolder;
import cn.com.yusys.yusp.bsp.resources.creator.impl.MappingCreator;
import cn.com.yusys.yusp.bsp.resources.creator.impl.NTMCreator;
import cn.com.yusys.yusp.bsp.resources.creator.impl.PropertiesCreator;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ResourcePortal {
    private static final ResourcePortal instance = new ResourcePortal();
    private final SpringContextRegistry _springContextRegistry = new SpringContextRegistry();
    private Map<String, IComm> outCommMap = new HashMap<String, IComm>();
    private final ResourceHolder resourceHolder = new ResourceHolder();

    private ResourcePortal() {
        ResourceCreator.addCreator(new MappingCreator());
        ResourceCreator.addCreator(new NTMCreator());
        ResourceCreator.addCreator(new PropertiesCreator());
    }

    public static ResourcePortal getInstance() {
        return instance;
    }

    public ResourceHolder getResourceHolder() {
        return this.resourceHolder;
    }

    public SpringContextRegistry getSpringContextRegistry() {
        return this._springContextRegistry;
    }

    public static String getCurDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = Calendar.getInstance().getTime();
        return format.format(date);
    }

    public Object getResource(String fileType, String filePath) throws ResourceException {
        ResourceHolder rh = ResourcePortal.getInstance().getResourceHolder();
        if (rh == null) {
            throw new ResourceException("Resource cache does not exist");
        }
        return rh.getResource(fileType, filePath);
    }

    public Map<String, IComm> getOutCommMap() {
        return this.outCommMap;
    }

    public void setOutCommMap(Map<String, IComm> outCommMap) {
        this.outCommMap = outCommMap;
    }
}

