/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.config;

import cn.com.yusys.yusp.bsp.app.config.BspBoot;
import cn.com.yusys.yusp.bsp.communication.out.AbstractOutAdapter;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.bean.SpringContextRegistry;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.comm.out.AbstractCommOut;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleHelper {
    private static final Logger logger = LoggerFactory.getLogger(ModuleHelper.class);
    private static final SpringContextRegistry _contextRegistry = ResourcePortal.getInstance().getSpringContextRegistry();

    public static void loadModule(String serviceName, String value) {
        logger.info("msname=" + serviceName + " bean=\n" + value);
        BspAppContext xc = new BspAppContext(value, BspBoot.applicationContext);
        _contextRegistry.addAppContext(serviceName, xc);
        xc.refresh();
        IComm comm = ModuleHelper.loadComm(xc, serviceName);
        if (comm == null) {
            return;
        }
        AbstractOutAdapter outAdapter = ModuleHelper.loadOutAdapter(xc, serviceName);
        if (outAdapter != null) {
            ((AbstractCommOut)comm).setOutAdapter(outAdapter);
            Map<String, IComm> outCommMap = ResourcePortal.getInstance().getOutCommMap();
            outCommMap.put(serviceName, comm);
        }
    }

    public static IComm loadComm(BspAppContext xc, String serviceName) {
        String[] commName = xc.getBeanNamesForType(IComm.class);
        if (commName.length == 0) {
            logger.error("Communication type is not configured");
            logger.warn("[{}]Configuration ignore", (Object)serviceName);
            xc.close();
            return null;
        }
        if (commName.length > 1) {
            logger.error("Multiple communication configurations");
            logger.warn("[{}]Configuration ignore", (Object)serviceName);
            xc.close();
            return null;
        }
        return (IComm)xc.getBean(commName[0]);
    }

    public static AbstractOutAdapter loadOutAdapter(BspAppContext xc, String serviceName) {
        String[] outAdapterName = xc.getBeanNamesForType(AbstractOutAdapter.class);
        if (outAdapterName.length > 1) {
            logger.warn("{},Does not support configuring multiple outgoing adapters, and the service does not start", (Object)serviceName);
            xc.close();
            return null;
        }
        if (outAdapterName.length == 1) {
            return (AbstractOutAdapter)xc.getBean(outAdapterName[0]);
        }
        return null;
    }
}

