/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.component.impl.dataformat;

import cn.com.yusys.yusp.bsp.component.AbstractComponent;
import cn.com.yusys.yusp.bsp.dataformat.DataFormatRegistry;
import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.DataFormat;
import cn.com.yusys.yusp.bsp.toolkit.common.Assert;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.DataFormatTools;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Map;

public class DataFormatComponent
extends AbstractComponent {
    public static final int MESSAGE_PACK = 0;
    public static final int MESSAGE_UNPACK = 1;
    private static final String[] COMPONENT_NAME = new String[]{"Packaging", "Unpacking"};
    private int packType = 1;
    private boolean useConfig;
    private String msgType;
    private String encode;
    private String messageName;
    private String unpackVarName;
    private String packVarName;
    private String mapVarName;

    @Override
    public String getComponentName() {
        return COMPONENT_NAME[this.getPackType()];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeComponent(Map<String, Object> context, String messageName) throws Exception {
        DataFormat dataFormat;
        AbstractExecutor messageExecutor;
        if (!this.isUseConfig()) {
            messageName = "Message profile not used";
            if (StringTools.isEmpty(this.getMsgType()) || StringTools.isEmpty(this.getEncode())) throw new Exception("Message format is not configured");
            Class<?> clazz = DataFormatRegistry._simpleDataformatRegistry.get(this.getMsgType());
            if (clazz == null) {
                throw new Exception("Message parser [" + this.getMsgType() + "] does not exist");
            }
            messageExecutor = (AbstractExecutor)clazz.newInstance();
            messageExecutor.setEncoding(this.getEncode());
            dataFormat = DataFormatRegistry.getDataformat(this.getMsgType(), this.getEncode());
        } else {
            dataFormat = DataFormatTools.loadDataFormat(messageName);
            if (dataFormat == null) {
                throw new Exception("Message format is not configured");
            }
            messageExecutor = DataFormatRegistry.getDataFormatExecutor(dataFormat.getImplClass());
            messageExecutor.setEncoding(dataFormat.getEncoding());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} @ {}, message=[{}]", new Object[]{messageExecutor.getExecutorName(), COMPONENT_NAME[this.getPackType()], messageName});
        }
        if (0 == this.getPackType()) {
            this.packDataFormat(messageExecutor, dataFormat, context);
            return;
        } else {
            this.unpackDataFormat(messageExecutor, dataFormat, context);
        }
    }

    @Override
    protected void executeComponent(Map<String, Object> context) throws Exception {
        String messageName = this.getMessageName(context);
        this.executeComponent(context, messageName);
    }

    private String getMessageName(Map<String, Object> context) throws Exception {
        if (StringTools.isEmpty(this.getMessageName())) {
            return null;
        }
        String fileName = DataFormatComponent.getInExpressStringValue(this.getMessageName(), context);
        if (StringTools.isEmpty(fileName)) {
            return null;
        }
        String folderPath = this.getModulePath(context);
        String msgPath = FileTools.getMsgPath(folderPath, fileName);
        if (StringTools.isEmpty(msgPath)) {
            throw new Exception("Message format [" + folderPath + "/" + fileName + "] is not configured");
        }
        return msgPath;
    }

    public void packDataFormat(AbstractExecutor<Object> messageExecutor, DataFormat dataFormat, Map<String, Object> context) throws Exception {
        Assert.notNull(this.getPackVarName(), "[Packing variable name] cannot be empty");
        if (!this.isUseConfig()) {
            messageExecutor.setAutoPackVar(this.getMapVarName());
        }
        messageExecutor.setRootContext(context);
        messageExecutor.setCurrentContext(context);
        messageExecutor.setModulePath(this.getModulePath(context));
        messageExecutor.pack(dataFormat);
        Object ret = messageExecutor.outputData();
        context.put(this.getPackVarName(), ret);
        this.logPackMessage(messageExecutor, ret);
    }

    private void logPackMessage(AbstractExecutor<Object> messageExecutor, Object ret) throws UnsupportedEncodingException {
        if (this.logger.isDebugEnabled()) {
            Object[] logParam;
            String logformat;
            if (ret == null) {
                return;
            }
            String logMsg = null;
            byte[] retByte = null;
            boolean printLen = true;
            if (ret instanceof byte[]) {
                retByte = (byte[])ret;
            } else if (ret instanceof ByteBuffer) {
                retByte = ((ByteBuffer)ret).array();
            } else if (ret instanceof Map) {
                Map map = (Map)ret;
                logMsg = map.toString();
                printLen = false;
            } else {
                retByte = ByteTools.getBytes(ret, messageExecutor.getEncoding());
                printLen = false;
            }
            if (logMsg == null) {
                logMsg = !this.printHex ? StringTools.getString(retByte, messageExecutor.getEncoding()) : StringTools.toHexTable(retByte);
            }
            if (messageExecutor.isHiddenInfo()) {
                if (printLen) {
                    logformat = "{} @ spell package, message [{}]: contains sensitive information, ignore";
                    logParam = new Object[]{this.getComponentName(), retByte.length};
                } else {
                    logformat = "{} @ spell package, the message contains sensitive information, ignore";
                    logParam = new Object[]{this.getComponentName()};
                }
            } else if (printLen) {
                logformat = "{} @ spell package, message[{}]:\n{}";
                logParam = new Object[]{this.getComponentName(), retByte.length, logMsg};
            } else {
                logformat = "{} @ spell package, message:\n{}";
                logParam = new Object[]{this.getComponentName(), logMsg};
            }
            this.logger.debug(logformat, logParam);
        }
    }

    public void unpackDataFormat(AbstractExecutor<Object> messageExecutor, DataFormat dataFormat, Map<String, Object> context) throws Exception {
        Assert.notNull(this.getUnpackVarName(), "[Unpacking variable name] cannot be empty");
        Object object = this.getInExpressObjectValue(this.getUnpackVarName(), context);
        if (object == null) {
            throw new Exception("Unpacking data does not exist");
        }
        messageExecutor.setRootContext(context);
        messageExecutor.setCurrentContext(context);
        messageExecutor.setModulePath(this.getModulePath(context));
        if (!this.isUseConfig()) {
            messageExecutor.setAutoUnpackVar(this.getMapVarName());
        }
        messageExecutor.unPack(dataFormat, object);
    }

    public int getPackType() {
        return this.packType;
    }

    public void setPackType(int packType) {
        this.packType = packType;
    }

    public boolean isUseConfig() {
        return this.useConfig;
    }

    public void setUseConfig(boolean useConfig) {
        this.useConfig = useConfig;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getEncode() {
        return this.encode;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    public String getUnpackVarName() {
        return this.unpackVarName;
    }

    public void setUnpackVarName(String unpackVarName) {
        this.unpackVarName = unpackVarName;
    }

    public String getPackVarName() {
        return this.packVarName;
    }

    public void setPackVarName(String packVarName) {
        this.packVarName = packVarName;
    }

    public String getMapVarName() {
        return this.mapVarName;
    }

    public void setMapVarName(String mapVarName) {
        this.mapVarName = mapVarName;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }
}

