/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.component;

import cn.com.yusys.yusp.bsp.component.AbstractComponent;
import cn.com.yusys.yusp.bsp.component.IComponent;
import cn.com.yusys.yusp.bsp.component.exception.ComponentException;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import java.util.List;
import java.util.Map;

public class CompositeComponent
extends AbstractComponent {
    private final List<IComponent> componentChain;
    private final String moduleName;
    private static final String COMPONENT_NAME = "CompositeComponent";

    public CompositeComponent(List<IComponent> componentChain, String moduleName) {
        this.componentChain = componentChain;
        this.moduleName = moduleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeComponent(Map<String, Object> context) throws ComponentException {
        if (this.componentChain != null) {
            Session session = (Session)context.get("T_SESSION");
            String _oldModuleName = session.getModuleName();
            try {
                session.setModuleName(this.moduleName);
                LogbackUtil.putLogInfo(this.moduleName, session.getSessionId());
                for (IComponent component : this.componentChain) {
                    this.logger.debug("{} @ Start", (Object)component.getComponentName());
                    try {
                        component.execute(context);
                    }
                    finally {
                        this.logger.debug("{} @ Stop", (Object)component.getComponentName());
                    }
                }
            }
            finally {
                if (!this.moduleName.equals(_oldModuleName)) {
                    session.setModuleName(_oldModuleName);
                    if (_oldModuleName != null) {
                        LogbackUtil.putLogInfo(_oldModuleName, session.getSessionId());
                    }
                }
            }
        }
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

