/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.in;

import cn.com.yusys.yusp.bsp.communication.AbstractAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.in.IInAdapter;
import cn.com.yusys.yusp.bsp.core.IAdapterDispatcher;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractInAdapter
extends AbstractAdapter
implements IInAdapter {
    protected IAdapterDispatcher dispatcher;
    protected Map<String, IRequest> usedRequestMap = new ConcurrentHashMap<String, IRequest>();

    public Map<String, IRequest> getUsedRequestMap() {
        return this.usedRequestMap;
    }

    public void setUsedRequestMap(Map<String, IRequest> usedRequestMap) {
        this.usedRequestMap = usedRequestMap;
    }

    @Override
    public void putRequest(String sessionId, IRequest request) {
        this.usedRequestMap.put(sessionId, request);
        request.setSessionId(sessionId);
        Object object = request.getDatasourceWrapper();
        if (object instanceof SocketWrapper) {
            SocketWrapper wrapper = (SocketWrapper)object;
            wrapper.setSessionId(sessionId);
        }
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        Iterator<IRequest> iter = this.getUsedRequestMap().values().iterator();
        try {
            while (iter.hasNext()) {
                IRequest req = iter.next();
                req.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getUsedRequestMap().clear();
    }

    @Override
    public void run() {
        try {
            this.beforeAction();
        }
        catch (Exception e1) {
            this.logger.error("{} @ Action preprocessing exception", (Object)this.getAdapterTypeName(), (Object)e1);
        }
        while (this.isAlive()) {
            try {
                IRequest req = this.makeRequest();
                if (req == null) continue;
                this.dispatcher.triggerRequest(req);
            }
            catch (Throwable e) {
                if (!this.isAlive()) continue;
                this.logger.error("{} @ Listening exveption", (Object)this.getAdapterTypeName(), (Object)e);
            }
        }
        LogbackUtil.removeLogInfo();
    }

    public abstract IRequest makeRequest() throws Exception;

    public abstract void unmakeRequest(IRequest var1) throws Exception;

    public void beforeAction() {
    }

    public IAdapterDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(IAdapterDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public void returnRequest(IRequest request) throws Exception {
        if (request.getSessionId() != null) {
            this.getUsedRequestMap().remove(request.getSessionId());
        }
        this.unmakeRequest(request);
        request.setSessionId(null);
        if (request.getDatasourceWrapper() instanceof SocketWrapper) {
            SocketWrapper wrapper = (SocketWrapper)request.getDatasourceWrapper();
            wrapper.setSessionId(null);
        }
    }

    @Override
    public int getAdapterType() {
        return 0;
    }

    public boolean isAvalible(IRequest request) {
        StreamRequest requestStream = (StreamRequest)request;
        return !requestStream.needToClose();
    }
}

