/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.swagger;

import cn.com.yusys.yusp.commons.ribbon.RibbonRuleFactory;
import cn.com.yusys.yusp.commons.ribbon.config.OrderedRibbonRuleFactory;
import cn.com.yusys.yusp.commons.swagger.config.SwaggerConfigurer;
import cn.com.yusys.yusp.commons.swagger.gateway.GatewayHostPortPreferRule;
import cn.com.yusys.yusp.commons.swagger.gateway.GatewaySwaggerResourcesProvider;
import cn.com.yusys.yusp.commons.swagger.gateway.web.rest.GatewaySwaggerHandlerResource;
import cn.com.yusys.yusp.commons.swagger.gateway.web.rest.GatewaySwaggerResource;
import com.netflix.loadbalancer.IRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;
import springfox.documentation.swagger.web.UiConfiguration;

@Configuration
@ConditionalOnClass(value={GatewayHostPortPreferRule.class, DiscoveryClient.class, UiConfiguration.class, RouteDefinitionLocator.class})
public class SwaggerGatewayAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SwaggerGatewayAutoConfiguration.class);

    @Bean
    @Primary
    public GatewaySwaggerResourcesProvider gatewaySwaggerResourcesProvider(@Value(value="${spring.application.name:webapp}") String serviceId, RouteDefinitionLocator locator) {
        return new GatewaySwaggerResourcesProvider(serviceId, locator);
    }

    @Bean
    @ConditionalOnMissingBean
    public GatewaySwaggerResource gatewaySwaggerResource(DiscoveryClient discoveryClient) {
        return new GatewaySwaggerResource(discoveryClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public GatewaySwaggerHandlerResource gatewaySwaggerHandlerResource(SwaggerResourcesProvider swaggerResourcesProvider, UiConfiguration uiConfiguration) {
        return new GatewaySwaggerHandlerResource(swaggerResourcesProvider, uiConfiguration);
    }

    @Bean
    @Order(value=-2147483648)
    public RibbonRuleFactory gatewayHostPortPreferRuleFactory() {
        return new OrderedRibbonRuleFactory(){

            public IRule getRibbonRule() {
                return new GatewayHostPortPreferRule();
            }

            public int getOrder() {
                return -2147483638;
            }
        };
    }

    @Bean
    @Order
    public SwaggerConfigurer configurer() {
        log.debug("Setting ui show mode is gateway");
        return ui -> ui.showExtensions(Boolean.valueOf(true));
    }
}

