/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.swagger;

import cn.com.yusys.yusp.commons.autoconfigure.swagger.SwaggerProperties;
import cn.com.yusys.yusp.commons.autoconfigure.swagger.YuSwaggerAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.swagger.YuSwaggerSecurityConfiguration;
import cn.com.yusys.yusp.commons.swagger.filter.ProductionSecurityFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import springfox.documentation.swagger.web.ApiResourceController;

@ConditionalOnClass(value={ProductionSecurityFilter.class, ApiResourceController.class})
@Import(value={YuSwaggerSecurityConfiguration.class})
@AutoConfigureAfter(value={YuSwaggerAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ServletSwaggerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ServletSwaggerAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public ProductionSecurityFilter productionSecurityFilter(SwaggerProperties swaggerProperties) {
        logger.debug("Init prod security filter");
        return new ProductionSecurityFilter(swaggerProperties.getApi().isProd());
    }
}

