/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.service.authority;

import cn.com.yusys.yusp.commons.autoconfigure.cache.redis.YuRedisAutoConfiguration;
import cn.com.yusys.yusp.commons.service.authority.ServiceAuthority;
import cn.com.yusys.yusp.commons.service.authority.redis.RedisCacheServiceAuthority;
import cn.com.yusys.yusp.commons.service.authority.web.filter.ServiceAuthorityFilter;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ServiceAuthority.class})
@AutoConfigureAfter(value={YuRedisAutoConfiguration.class})
public class ServiceAuthorityAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(ServiceAuthorityAutoConfiguration.class);
    private static final int FILTER_ORDER_SERVICE_AUTHORITY = 96;

    @Bean
    @ConditionalOnMissingBean(value={ServiceAuthority.class})
    public ServiceAuthority redisCacheServiceAuthority() {
        this.logger.info("Service authentication query, load AuthRuleServiceCacheImpl, based on cache");
        return new RedisCacheServiceAuthority();
    }

    @Bean
    public FilterRegistrationBean<Filter> serviceAuthorityFilterBean(@Value(value="${spring.application.name:app}") String applicationName, ServiceAuthority serviceAuthority) {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new ServiceAuthorityFilter(applicationName, serviceAuthority), new ServletRegistrationBean[0]);
        bean.setOrder(96);
        return bean;
    }
}

