/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.ribbon;

import cn.com.yusys.yusp.commons.ribbon.RouteMappingLocator;
import cn.com.yusys.yusp.commons.ribbon.config.ConfigRouteMappingLocator;
import cn.com.yusys.yusp.commons.ribbon.config.ServiceMappingProperties;
import cn.com.yusys.yusp.commons.ribbon.feign.RouteFeignBeanDefinitionRegistryPostProcessor;
import cn.com.yusys.yusp.commons.ribbon.testcase.rest.RouteRestTemplate;
import cn.com.yusys.yusp.commons.ribbon.zuul.ZuulPropertiesBeanPostProcessor;
import cn.com.yusys.yusp.commons.ribbon.zuul.ZuulPropertiesBindingHandlerAdvise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={RouteMappingLocator.class})
@EnableConfigurationProperties(value={ServiceMappingProperties.class})
public class RouteAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RouteAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={ZuulProperties.class, ZuulPropertiesBeanPostProcessor.class})
    static class ZuulConfiguration {
        ZuulConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ZuulPropertiesBeanPostProcessor zuulPropertiesBeanPostProcessor(ServiceMappingProperties properties) {
            return new ZuulPropertiesBeanPostProcessor(properties);
        }

        @Bean
        @ConditionalOnMissingBean
        public ZuulPropertiesBindingHandlerAdvise zuulPropertiesBindingHandlerAdvise() {
            return new ZuulPropertiesBindingHandlerAdvise();
        }
    }

    @Configuration
    @ConditionalOnClass(value={RestTemplate.class, RouteRestTemplate.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class RestTemplateConfiguration {
        RestTemplateConfiguration() {
        }

        @LoadBalanced
        @Bean(value={"routeRestTemplate"})
        @ConditionalOnMissingBean
        public RouteRestTemplate routeRestTemplate(RestTemplateBuilder restTemplateBuilder, RouteMappingLocator locator) {
            log.debug("Inject RouteRestTemplate, Add interceptors and message converters.");
            RouteRestTemplate routeRestTemplate = (RouteRestTemplate)restTemplateBuilder.build(RouteRestTemplate.class);
            routeRestTemplate.setRouteMappingLocator(locator);
            return routeRestTemplate;
        }
    }

    @Configuration
    @ConditionalOnClass(value={RouteFeignBeanDefinitionRegistryPostProcessor.class, LoadBalancerFeignClient.class})
    static class FeignRouteConfiguration {
        FeignRouteConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RouteFeignBeanDefinitionRegistryPostProcessor routeFeignBeanDefinitionRegistryPostProcessor(RouteMappingLocator routeMappingLocator) {
            return new RouteFeignBeanDefinitionRegistryPostProcessor(routeMappingLocator);
        }
    }

    @Configuration
    @ConditionalOnClass(value={RouteMappingLocator.class})
    static class RouteMappingAutoConfiguration {
        RouteMappingAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RouteMappingLocator routeMappingLocator(ServiceMappingProperties properties) {
            return new ConfigRouteMappingLocator(properties);
        }
    }
}

