/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.ribbon;

import cn.com.yusys.yusp.commons.ribbon.CompositeRule;
import cn.com.yusys.yusp.commons.ribbon.RibbonRuleFactory;
import cn.com.yusys.yusp.commons.ribbon.config.OrderedRibbonRuleFactory;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.loadbalancer.ServerListUpdater;
import com.netflix.loadbalancer.ZoneAwareLoadBalancer;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.ribbon.PropertiesFactory;
import org.springframework.cloud.netflix.ribbon.RibbonClientName;
import org.springframework.context.annotation.Bean;

public class RibbonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RibbonAutoConfiguration.class);
    public static final String ROUND_ROBIN_RULE_FACTORY = "roundRobinRuleFactory";
    @RibbonClientName
    private final String name = "client";
    private final PropertiesFactory propertiesFactory;

    public RibbonAutoConfiguration(PropertiesFactory propertiesFactory) {
        this.propertiesFactory = propertiesFactory;
    }

    @Bean
    public BeanPostProcessor iClientConfigBeanPostProcessor(ObjectProvider<RibbonRuleFactory> ribbonRuleFactories) {
        return new IClientConfigBeanPostProcessor(ribbonRuleFactories);
    }

    @Bean(name={"roundRobinRuleFactory"})
    @ConditionalOnMissingBean(name={"roundRobinRuleFactory"})
    public RibbonRuleFactory roundRobinRuleFactory() {
        return new OrderedRibbonRuleFactory(){

            public IRule getRibbonRule() {
                return new RoundRobinRule();
            }

            public int getOrder() {
                return 0x7FFFFFF5;
            }
        };
    }

    @Bean
    public ILoadBalancer ribbonLoadBalancer(IClientConfig config, ServerList<Server> serverList, ServerListFilter<Server> serverListFilter, IPing ping, ServerListUpdater serverListUpdater) {
        IRule rule;
        if (this.propertiesFactory.isSet(ILoadBalancer.class, "client")) {
            return (ILoadBalancer)this.propertiesFactory.get(ILoadBalancer.class, config, "client");
        }
        if (this.propertiesFactory.isSet(IRule.class, "client")) {
            rule = (IRule)this.propertiesFactory.get(IRule.class, config, "client");
        } else {
            log.debug("Load Composite Rule,when first rule return null,it will be exec continue!");
            CompositeRule compositeRule = new CompositeRule();
            compositeRule.initWithNiwsConfig(config);
            rule = compositeRule;
        }
        log.debug("Load default ZoneAwareLoadBalancer use Composite Rule!");
        return new ZoneAwareLoadBalancer(config, rule, ping, serverList, serverListFilter, serverListUpdater);
    }

    static class IClientConfigBeanPostProcessor
    implements BeanPostProcessor {
        ObjectProvider<RibbonRuleFactory> ribbonRuleFactories;

        public IClientConfigBeanPostProcessor(ObjectProvider<RibbonRuleFactory> ribbonRuleFactories) {
            this.ribbonRuleFactories = ribbonRuleFactories;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (IClientConfig.class.isAssignableFrom(bean.getClass())) {
                IClientConfig iClientConfig = (IClientConfig)bean;
                List ruleList = this.ribbonRuleFactories.orderedStream().map(RibbonRuleFactory::getRibbonRule).collect(Collectors.toList());
                CompositeRule compositeRule = new CompositeRule();
                compositeRule.setRuleList(ruleList);
                iClientConfig.set((IClientConfigKey)CompositeRule.getInstance(), (Object)compositeRule);
                return iClientConfig;
            }
            return bean;
        }
    }
}

