/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.oplog;

import cn.com.yusys.yusp.commons.autoconfigure.oplog.OpLogProperties;
import cn.com.yusys.yusp.commons.autoconfigure.oplog.RabbmitProperties;
import cn.com.yusys.yusp.commons.oplog.listener.OpLogMQListener;
import cn.com.yusys.yusp.commons.oplog.listener.OpLogProcess;
import cn.com.yusys.yusp.commons.oplog.send.OpLogUpload;
import cn.com.yusys.yusp.commons.oplog.util.OpLogUtils;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@ConditionalOnProperty(name={"yusp.op-log.enabled"})
@ConditionalOnClass(value={OpLogUpload.class, RabbitTemplate.class, ConnectionFactory.class})
@EnableConfigurationProperties(value={RabbmitProperties.class, OpLogProperties.class})
public class RabbmitAutoConfiguration {
    @Bean(name={"yuspRabbmitConnection"})
    public ConnectionFactory yuspRabbmitFactory(RabbmitProperties properties) {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        connectionFactory.setAddresses(properties.getAddresses());
        connectionFactory.setUsername(properties.getUsername());
        connectionFactory.setPassword(properties.getPassword());
        String virtualHost = properties.getVirtualHost();
        if (null != virtualHost && !"".equals(virtualHost)) {
            connectionFactory.setVirtualHost(virtualHost);
        }
        connectionFactory.setChannelCacheSize(5);
        return connectionFactory;
    }

    @Bean(name={"yuspRabbitTemplate"})
    public RabbitTemplate yuspRabbitTemplate(@Qualifier(value="yuspRabbmitConnection") ConnectionFactory connectionFactory) {
        RabbitTemplate yuspRabbitTemplate = new RabbitTemplate(connectionFactory);
        return yuspRabbitTemplate;
    }

    @Bean(name={"yuspRabbitListener"})
    public SimpleRabbitListenerContainerFactory yuspRabbitListener(SimpleRabbitListenerContainerFactoryConfigurer configurer, @Qualifier(value="yuspRabbmitConnection") ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setAcknowledgeMode(AcknowledgeMode.AUTO);
        configurer.configure(factory, connectionFactory);
        return factory;
    }

    @Bean
    public Queue yuspLogMq() {
        return new Queue("yusp-op-log", true);
    }

    @Bean
    public Queue yuspExceptionLogMq() {
        return new Queue("yusp-exception-log", true);
    }

    @Bean
    public OpLogUpload opLogUpload(@Qualifier(value="yuspRabbitTemplate") RabbitTemplate rabbitTemplate, OpLogProperties opLogProperties) {
        return new OpLogUpload(rabbitTemplate, opLogProperties.getBatchSize(), opLogProperties.isEnabled());
    }

    @Bean
    public OpLogUtils mqSendUtils() {
        return new OpLogUtils();
    }

    @Bean
    @ConditionalOnProperty(value={"yusp.op-log.listener"}, havingValue="true")
    public OpLogMQListener opLogMQListener(@Autowired(required=false) OpLogProcess opLogProcess) {
        return new OpLogMQListener(opLogProcess);
    }
}

