/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.openfeign;

import cn.com.yusys.yusp.commons.openfeign.interceptor.FeignInterceptor;
import cn.com.yusys.yusp.commons.openfeign.util.FeignUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class FeignBeanPostProcessor
implements BeanPostProcessor {
    private Logger logger = LoggerFactory.getLogger(FeignBeanPostProcessor.class);
    private List<FeignInterceptor> feignInterceptorList;
    private final boolean canProxy;

    public FeignBeanPostProcessor(List<FeignInterceptor> feignInterceptorList) {
        this.feignInterceptorList = feignInterceptorList;
        this.canProxy = feignInterceptorList != null && !feignInterceptorList.isEmpty();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        try {
            if (this.canProxy && this.isFeign(bean)) {
                this.logger.info("Proxy bean:{} with Feign interceptor", (Object)beanName);
                if (this.feignInterceptorList != null && !this.feignInterceptorList.isEmpty()) {
                    for (FeignInterceptor feignInterceptor : this.feignInterceptorList) {
                        bean = feignInterceptor.plugin(bean);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Parsed proxy object", (Throwable)e);
        }
        return bean;
    }

    private boolean isFeign(Object bean) {
        return FeignUtils.isFeign((Object)bean);
    }
}

