/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper;

import cn.com.yusys.yusp.commons.mybatis.MapperScanBasePackage;
import cn.com.yusys.yusp.commons.scan.BasePackage;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.ibatis.annotations.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.util.StringUtils;
import tk.mybatis.spring.mapper.MapperScannerConfigurer;

public class MapperMybatisMapperScanAutoConfiguration {

    static class MapperMybatisMapperBeanDefinitionRegistryPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private static final Logger logger = LoggerFactory.getLogger(MapperMybatisMapperBeanDefinitionRegistryPostProcessor.class);

        MapperMybatisMapperBeanDefinitionRegistryPostProcessor() {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (registry instanceof DefaultListableBeanFactory) {
                DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)registry;
                List<String> packages = null;
                try {
                    String[] beanNames = beanFactory.getBeanNamesForType(MapperScanBasePackage.class);
                    packages = Arrays.stream(beanNames).map(beanName -> (MapperScanBasePackage)beanFactory.getBean(beanName)).map(BasePackage::basePackage).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                }
                catch (Exception e) {
                    logger.warn("Please config mybatis mapper scan path or add @MapperScan annotation!");
                }
                if (CollectionUtils.isEmpty(packages)) {
                    logger.warn("Not Config default scan package!");
                    return;
                }
                if (logger.isDebugEnabled()) {
                    packages.forEach(pkg -> logger.debug("Using auto-configuration base package '{}'", pkg));
                    logger.debug("Searching for mappers annotated with @Mapper");
                }
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MapperScannerConfigurer.class);
                builder.addPropertyValue("processPropertyPlaceHolders", (Object)true);
                builder.addPropertyValue("annotationClass", Mapper.class);
                builder.addPropertyValue("basePackage", (Object)StringUtils.collectionToCommaDelimitedString(packages));
                registry.registerBeanDefinition(new StringJoiner(MapperScannerConfigurer.class.getName()).add("-MapperScan").toString(), (BeanDefinition)builder.getBeanDefinition());
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

