/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis.plus;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.ExecutorType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@ConfigurationProperties(prefix="mybatis-plus")
public class MybatisPlusProperties {
    public static final String MYBATIS_PLUS_PREFIX = "mybatis-plus";
    private static final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private String configLocation;
    private String[] mapperLocations = new String[]{"classpath*:/mapper/**/*.xml"};
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private String typeHandlersPackage;
    private boolean checkConfigLocation = false;
    private ExecutorType executorType;
    private Class<? extends LanguageDriver> defaultScriptingLanguageDriver;
    private Properties configurationProperties;
    @NestedConfigurationProperty
    private MybatisConfiguration configuration;
    private String typeEnumsPackage;
    @NestedConfigurationProperty
    private GlobalConfig globalConfig = GlobalConfigUtils.defaults();
    private final BatchOperationConfig batchConfig = new BatchOperationConfig();
    private boolean fillDynamicSql = false;
    private final AutoPopulate autoPopulate = new AutoPopulate();
    private final DateTypeHandler dateTypeHandler = new DateTypeHandler();
    private final Page page = new Page();

    public AutoPopulate getAutoPopulate() {
        return this.autoPopulate;
    }

    public DateTypeHandler getDateTypeHandler() {
        return this.dateTypeHandler;
    }

    public Page getPage() {
        return this.page;
    }

    public Resource[] resolveMapperLocations() {
        return (Resource[])Stream.of((Object[])Optional.ofNullable(this.mapperLocations).orElse(new String[0])).flatMap(location -> Stream.of(this.getResources((String)location))).toArray(Resource[]::new);
    }

    private Resource[] getResources(String location) {
        try {
            return resourceResolver.getResources(location);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    public Class<?> getTypeAliasesSuperType() {
        return this.typeAliasesSuperType;
    }

    public String getTypeHandlersPackage() {
        return this.typeHandlersPackage;
    }

    public boolean isCheckConfigLocation() {
        return this.checkConfigLocation;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public Class<? extends LanguageDriver> getDefaultScriptingLanguageDriver() {
        return this.defaultScriptingLanguageDriver;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public MybatisConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getTypeEnumsPackage() {
        return this.typeEnumsPackage;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public MybatisPlusProperties setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
        return this;
    }

    public MybatisPlusProperties setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
        return this;
    }

    public MybatisPlusProperties setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
        return this;
    }

    public MybatisPlusProperties setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
        return this;
    }

    public MybatisPlusProperties setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
        return this;
    }

    public MybatisPlusProperties setCheckConfigLocation(boolean checkConfigLocation) {
        this.checkConfigLocation = checkConfigLocation;
        return this;
    }

    public MybatisPlusProperties setExecutorType(ExecutorType executorType) {
        this.executorType = executorType;
        return this;
    }

    public MybatisPlusProperties setDefaultScriptingLanguageDriver(Class<? extends LanguageDriver> defaultScriptingLanguageDriver) {
        this.defaultScriptingLanguageDriver = defaultScriptingLanguageDriver;
        return this;
    }

    public MybatisPlusProperties setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
        return this;
    }

    public MybatisPlusProperties setConfiguration(MybatisConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public MybatisPlusProperties setTypeEnumsPackage(String typeEnumsPackage) {
        this.typeEnumsPackage = typeEnumsPackage;
        return this;
    }

    public MybatisPlusProperties setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public BatchOperationConfig getBatchConfig() {
        return this.batchConfig;
    }

    public boolean isFillDynamicSql() {
        return this.fillDynamicSql;
    }

    public void setFillDynamicSql(boolean fillDynamicSql) {
        this.fillDynamicSql = fillDynamicSql;
    }

    public String toString() {
        return "MybatisPlusProperties(configLocation=" + this.getConfigLocation() + ", mapperLocations=" + Arrays.deepToString(this.getMapperLocations()) + ", typeAliasesPackage=" + this.getTypeAliasesPackage() + ", typeAliasesSuperType=" + this.getTypeAliasesSuperType() + ", typeHandlersPackage=" + this.getTypeHandlersPackage() + ", checkConfigLocation=" + this.isCheckConfigLocation() + ", executorType=" + this.getExecutorType() + ", defaultScriptingLanguageDriver=" + this.getDefaultScriptingLanguageDriver() + ", configurationProperties=" + this.getConfigurationProperties() + ", configuration=" + this.getConfiguration() + ", typeEnumsPackage=" + this.getTypeEnumsPackage() + ", globalConfig=" + this.getGlobalConfig() + ")";
    }

    public class Page {
        protected boolean overflow = false;
        protected long maxLimit = 1000L;

        public boolean isOverflow() {
            return this.overflow;
        }

        public void setOverflow(boolean overflow) {
            this.overflow = overflow;
        }

        public Long getMaxLimit() {
            return this.maxLimit;
        }

        public void setMaxLimit(Long maxLimit) {
            this.maxLimit = maxLimit;
        }
    }

    public class DateTypeHandler {
        private boolean enabled = false;
        private String dateFormatter;
        private String dateTimeFormatter;
        private String timeZone;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getDateFormatter() {
            return this.dateFormatter;
        }

        public void setDateFormatter(String dateFormatter) {
            this.dateFormatter = dateFormatter;
        }

        public String getDateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public void setDateTimeFormatter(String dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }
    }

    public class AutoPopulate {
        private boolean annotationConstraint = false;
        private Map<String, String> insertFields;
        private Map<String, String> updateFields;

        public Map<String, String> getInsertFields() {
            return this.insertFields;
        }

        public void setInsertFields(Map<String, String> insertFields) {
            this.insertFields = insertFields;
        }

        public Map<String, String> getUpdateFields() {
            return this.updateFields;
        }

        public void setUpdateFields(Map<String, String> updateFields) {
            this.updateFields = updateFields;
        }

        public boolean isAnnotationConstraint() {
            return this.annotationConstraint;
        }

        public void setAnnotationConstraint(boolean annotationConstraint) {
            this.annotationConstraint = annotationConstraint;
        }
    }

    public class BatchOperationConfig {
        private int flushSize = 1000;

        public int getFlushSize() {
            return this.flushSize;
        }

        public void setFlushSize(int flushSize) {
            this.flushSize = flushSize;
        }
    }
}

