/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.idempotent;

import cn.com.yusys.yusp.commons.autoconfigure.idempotent.IdempotentProperties;
import cn.com.yusys.yusp.commons.idempotent.IdempotentAspect;
import cn.com.yusys.yusp.commons.idempotent.IdempotentStore;
import cn.com.yusys.yusp.commons.idempotent.IdempotentUtils;
import cn.com.yusys.yusp.commons.idempotent.annotation.Idempotent;
import cn.com.yusys.yusp.commons.idempotent.support.DatabaseIdempotentStore;
import cn.com.yusys.yusp.commons.idempotent.support.RedisIdempotentStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@ConditionalOnClass(value={Idempotent.class})
@EnableConfigurationProperties(value={IdempotentProperties.class})
public class IdempotentAutoConfiguration {
    IdempotentProperties properties;

    public IdempotentAutoConfiguration(IdempotentProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="'redis'.equals('${yusp.idempotent.store-type:redis}')")
    public IdempotentStore redisIdempotentStore(StringRedisTemplate redisTemplate) {
        return new RedisIdempotentStore(redisTemplate, this.properties.getRedis().getCacheName(), this.properties.getRedis().getExpire());
    }

    @Bean
    @ConditionalOnProperty(prefix="yusp.idempotent", name={"store-type"}, havingValue="database")
    public IdempotentStore dbIdempotentStore(JdbcTemplate jdbcTemplate) {
        return new DatabaseIdempotentStore(jdbcTemplate, this.properties.getDatabase().getTableName(), this.properties.getDatabase().isEnabledInit());
    }

    @Bean
    @Order
    public IdempotentAspect idempotentAspect() {
        return new IdempotentAspect();
    }

    @Autowired
    public void initIdempotentUtils(IdempotentStore store) {
        IdempotentUtils.setGlobalParams((IdempotentStore)store);
    }
}

