/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.file;

import cn.com.yusys.yusp.commons.autoconfigure.file.FileProperties;
import cn.com.yusys.yusp.commons.file.server.AbstractFileServer;
import cn.com.yusys.yusp.commons.file.server.ConnectConfig;
import cn.com.yusys.yusp.commons.file.server.fastdfs.FastDfsFileServer;
import cn.com.yusys.yusp.commons.file.server.localdisk.LocalDiskFileServer;
import cn.com.yusys.yusp.commons.file.server.sftp.SftpFileServer;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplateFactory;
import cn.com.yusys.yusp.commons.file.util.FileInfoUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;

public class FileServerPostProcessor
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(FileServerPostProcessor.class);
    private BeanDefinitionRegistry registry;
    private ApplicationContext applicationContext;
    private final String fastDfsCommandServiceBeanName;

    public FileServerPostProcessor(String fastDfsCommandServiceBeanName) {
        this.fastDfsCommandServiceBeanName = fastDfsCommandServiceBeanName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConfigurationProperties annotation = FileProperties.class.getAnnotation(ConfigurationProperties.class);
        FileProperties properties = new FileProperties();
        Binder binder = Binder.get((Environment)this.applicationContext.getEnvironment());
        binder.bind(annotation.prefix(), Bindable.ofInstance((Object)properties).withAnnotations(new Annotation[]{annotation}));
        FileInfoUtils.setFastDfsConfigs(properties.getFastdfses());
        this.register(properties);
        logger.info("File server and File system template bean has register finish!");
    }

    private void register(FileProperties fileProperties) {
        FileServerPostProcessor.register(this.registry, LocalDiskFileServer.class, fileProperties.getLocaldisks(), fileProperties.getConnectionPool(), null);
        FileServerPostProcessor.register(this.registry, SftpFileServer.class, fileProperties.getSftps(), fileProperties.getConnectionPool(), null);
        FileServerPostProcessor.register(this.registry, FastDfsFileServer.class, fileProperties.getFastdfses(), fileProperties.getConnectionPool(), beanDefinitionBuilder -> beanDefinitionBuilder.addConstructorArgReference(this.fastDfsCommandServiceBeanName));
        FileProperties.Temp temp = fileProperties.getTemp();
        if (StringUtils.nonBlank((CharSequence)temp.getServerNameRef()) && StringUtils.nonBlank((CharSequence)temp.getDefaultPath())) {
            BeanDefinitionBuilder tempBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(FileSystemTemplateFactory.class);
            tempBeanBuilder.addConstructorArgReference(temp.getServerNameRef());
            tempBeanBuilder.addPropertyValue("defaultPath", (Object)temp.getDefaultPath());
            this.registry.registerBeanDefinition("tmpFileTemplate", (BeanDefinition)tempBeanBuilder.getBeanDefinition());
        }
    }

    private static <T extends ConnectConfig> void register(BeanDefinitionRegistry registry, Class<? extends AbstractFileServer<T>> fileServerClassType, List<T> configs, FileProperties.ConnectionPool<?> connectionPool, Consumer<BeanDefinitionBuilder> fileServerConsumer) {
        if (CollectionUtils.nonEmpty(configs)) {
            for (ConnectConfig config : configs) {
                BeanDefinitionBuilder serverBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(fileServerClassType);
                serverBeanBuilder.addConstructorArgValue((Object)config.getServerName());
                serverBeanBuilder.addConstructorArgValue((Object)config);
                serverBeanBuilder.addConstructorArgValue(connectionPool);
                serverBeanBuilder.addPropertyValue("homePath", (Object)config.getHomePath());
                if (Objects.nonNull(fileServerConsumer)) {
                    fileServerConsumer.accept(serverBeanBuilder);
                }
                registry.registerBeanDefinition(config.getServerName(), (BeanDefinition)serverBeanBuilder.getBeanDefinition());
                BeanDefinitionBuilder templateBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(FileSystemTemplateFactory.class);
                templateBeanBuilder.addConstructorArgReference(config.getServerName());
                templateBeanBuilder.addPropertyValue("defaultPath", (Object)config.getDefaultPath());
                registry.registerBeanDefinition(config.getTemplateName(), (BeanDefinition)templateBeanBuilder.getBeanDefinition());
            }
        }
    }
}

