/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.exception;

import cn.com.yusys.yusp.commons.biz.BizMvcHandlerInterceptor;
import cn.com.yusys.yusp.commons.exception.fegin.FeignErrorDecoder;
import cn.com.yusys.yusp.commons.exception.fegin.FeignRequestTagInterceptor;
import cn.com.yusys.yusp.commons.exception.rest.BizExceptionResponseInterceptor;
import cn.com.yusys.yusp.commons.exception.web.ExceptionTranslator;
import cn.com.yusys.yusp.commons.exception.web.adapter.BizMvcHandlerInterceptAdapter;
import cn.com.yusys.yusp.commons.exception.web.handler.ExceptionHandler;
import cn.com.yusys.yusp.commons.exception.web.handler.impl.BizExceptionHandler;
import cn.com.yusys.yusp.commons.exception.web.handler.impl.HystrixRuntimeExceptionHandler;
import cn.com.yusys.yusp.commons.exception.web.handler.impl.PlatformExceptionHandler;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.http.client.ClientHttpRequestInterceptor;

@Configuration
@ConditionalOnClass(value={ExceptionHandler.class})
@ConditionalOnProperty(prefix="yusp.exception", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class WebExceptionAutoConfiguration {
    @Bean
    public ExceptionHandler<?> bizExceptionHandler(@Value(value="${yusp..exception.biz.response-status:200}") int status, @Value(value="${yusp..exception.biz.feign-handled:true}") boolean handleFeign) {
        return new BizExceptionHandler(status, handleFeign);
    }

    @Bean
    public ExceptionHandler<?> platformExceptionHandler() {
        return new PlatformExceptionHandler();
    }

    @Bean
    @ConditionalOnClass(name={"com.netflix.hystrix.exception.HystrixRuntimeException"})
    public ExceptionHandler<?> hystrixRuntimeExceptionHandler(BizExceptionHandler bizExceptionHandler) {
        return new HystrixRuntimeExceptionHandler(bizExceptionHandler);
    }

    @Bean
    public ExceptionTranslator exceptionTranslator(ObjectProvider<List<ExceptionHandler<?>>> listObjectProvider) {
        List exceptionHandlers = (List)listObjectProvider.getIfAvailable();
        if (CollectionUtils.nonEmpty((Collection)exceptionHandlers)) {
            AnnotationAwareOrderComparator.sort((List)exceptionHandlers);
        }
        return new ExceptionTranslator(exceptionHandlers);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={ClientHttpRequestInterceptor.class})
    public BizExceptionResponseInterceptor bizExceptionResponseInterceptor() {
        return new BizExceptionResponseInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplateCustomizer bizExceptionTemplateCustomizer(BizExceptionResponseInterceptor responseInterceptor) {
        return restTemplate -> restTemplate.getInterceptors().add(responseInterceptor);
    }

    @Configuration
    @ConditionalOnClass(value={BizMvcHandlerInterceptor.class, ExceptionTranslator.class})
    @AutoConfigureAfter(value={WebExceptionAutoConfiguration.class})
    static class BizMvcHandlerInterceptorAdapterAutoConfiguration {
        BizMvcHandlerInterceptorAdapterAutoConfiguration() {
        }

        @Bean
        @Order(value=-2147483648)
        public BizMvcHandlerInterceptor webExceptionHandlerAdapter(ExceptionTranslator exceptionTranslator) {
            return new BizMvcHandlerInterceptAdapter(exceptionTranslator);
        }
    }

    @Configuration
    @ConditionalOnClass(name={"feign.Feign", "org.springframework.cloud.openfeign.FeignContext"}, value={FeignErrorDecoder.class})
    static class FeignErrorExceptionAutoConfiguration {
        FeignErrorExceptionAutoConfiguration() {
        }

        @Bean
        public FeignErrorDecoder feignErrorDecoder() {
            return new FeignErrorDecoder();
        }

        @Bean
        public FeignRequestTagInterceptor feignRequestTagInterceptor() {
            return new FeignRequestTagInterceptor();
        }
    }
}

