/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.document.excel;

import cn.com.yusys.yusp.commons.autoconfigure.document.excel.ExcelProperties;
import cn.com.yusys.yusp.commons.excelcsv.ExporterImporter;
import cn.com.yusys.yusp.commons.excelcsv.async.AsyncPoolServiceExecutor;
import cn.com.yusys.yusp.commons.excelcsv.async.SpringTransaction;
import cn.com.yusys.yusp.commons.excelcsv.async.Transaction;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.excelcsv.handle.IProgress;
import cn.com.yusys.yusp.commons.excelcsv.handle.impl.DefaultRedisProgress;
import cn.com.yusys.yusp.commons.excelcsv.web.rest.ExportProgressResource;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@ConditionalOnClass(value={ExporterImporter.class, DataHandle.class, AsyncPoolServiceExecutor.class})
@EnableConfigurationProperties(value={ExcelProperties.class})
public class ExcelCsvAutoConfiguration {
    private final ExcelProperties excelProperties;
    public static final String EXCEL_CSV_EXECUTOR = "ExcelCsvExecutorService";

    public ExcelCsvAutoConfiguration(ExcelProperties excelProperties) {
        this.excelProperties = excelProperties;
    }

    @Bean(name={"ExcelCsvExecutorService"})
    public ExecutorService executorService() {
        return new ThreadPoolExecutor(0, this.excelProperties.getMaxThreads() <= 0 ? Runtime.getRuntime().availableProcessors() * 4 : this.excelProperties.getMaxThreads(), 300L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(this.excelProperties.getQueueSize() <= 0 ? 10000 : this.excelProperties.getQueueSize()));
    }

    @Bean
    @DependsOn(value={"ExcelCsvExecutorService"})
    @ConditionalOnBean(value={IProgress.class})
    public AsyncPoolServiceExecutor excelCsvPoolServiceExecutor(@Qualifier(value="ExcelCsvExecutorService") ExecutorService executorService, IProgress progress, ObjectProvider<Transaction> transaction) {
        return new AsyncPoolServiceExecutor(executorService, this.excelProperties.getMaxPages(), this.excelProperties.getPageSize(), this.excelProperties.getSheetMaxRow(), this.excelProperties.getTempDir(), progress, (Transaction)transaction.getIfAvailable());
    }

    @Configuration
    @ConditionalOnClass(value={DataSourceTransactionManager.class, Transaction.class})
    @ConditionalOnBean(value={DataSourceTransactionManager.class})
    public static class AsyncImportTransactionAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public Transaction springTransaction(DataSourceTransactionManager transactionManager) {
            return new SpringTransaction(transactionManager);
        }
    }

    @Configuration
    @ConditionalOnClass(value={StringRedisTemplate.class, IProgress.class})
    public static class ProgressAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={IProgress.class})
        public IProgress progress(StringRedisTemplate redisTemplate, @Value(value="${yusp.cache.ttl:720}") long timeout) {
            return new DefaultRedisProgress(redisTemplate, timeout);
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={IProgress.class})
    public static class WebRestAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public ExportProgressResource exportProgressResource(IProgress iProgress) {
            return new ExportProgressResource(iProgress);
        }
    }
}

