/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.distributed.lock;

import cn.com.yusys.yusp.commons.autoconfigure.distributed.lock.LockProperties;
import cn.com.yusys.yusp.commons.distributed.lock.Lock;
import cn.com.yusys.yusp.commons.distributed.lock.impl.DatabaseDistributedLock;
import cn.com.yusys.yusp.commons.distributed.lock.impl.DistributedLock;
import cn.com.yusys.yusp.commons.distributed.lock.impl.LockImpl;
import cn.com.yusys.yusp.commons.distributed.lock.impl.ZookeeperDistributedLock;
import cn.com.yusys.yusp.commons.distributed.lock.impl.db.mapper.LockInfoMapper;
import cn.com.yusys.yusp.commons.distributed.lock.impl.db.service.LockInfoService;
import cn.com.yusys.yusp.commons.mybatis.MapperScanBasePackage;
import java.util.Collections;
import javax.sql.DataSource;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Lock.class})
public class LockAutoConfiguration {
    public static final String LOCK_PREFIX = "yusp.lock";

    @Configuration
    @ConditionalOnClass(value={Lock.class})
    @AutoConfigureAfter(value={ZookeeperDistributedLockAutoConfiguration.class, DatabaseDistributedLockAutoConfiguration.class})
    @ConditionalOnProperty(prefix="yusp.lock", name={"enabled"}, matchIfMissing=true)
    static class DistributedLockAutoConfiguration {
        DistributedLockAutoConfiguration() {
        }

        @Bean
        public Lock lockImpl(DistributedLock distributedLock) {
            return new LockImpl(distributedLock);
        }
    }

    @Configuration
    @ConditionalOnClass(value={CuratorFramework.class, Lock.class})
    @ConditionalOnExpression(value="'zookeeper'.equals('${yusp.lock.type:zookeeper}')")
    @EnableConfigurationProperties(value={LockProperties.class})
    static class ZookeeperDistributedLockAutoConfiguration {
        ZookeeperDistributedLockAutoConfiguration() {
        }

        @Bean
        public CuratorFramework curatorFramework(LockProperties properties) {
            CuratorFramework zookeeperClient = CuratorFrameworkFactory.newClient((String)properties.getZookeeper().getAddress(), (int)properties.getZookeeper().getSessionTimeout(), (int)properties.getZookeeper().getConnectionTimeout(), (RetryPolicy)new RetryNTimes(properties.getZookeeper().getRetryNum(), properties.getZookeeper().getElapsedTime()));
            zookeeperClient.start();
            return zookeeperClient;
        }

        @Bean
        public DistributedLock zookeeperDistributedLock(CuratorFramework zookeeperClient) {
            return new ZookeeperDistributedLock(zookeeperClient);
        }
    }

    @Configuration
    @ConditionalOnSingleCandidate(value=DataSource.class)
    @ConditionalOnProperty(prefix="yusp.lock", name={"type"}, havingValue="database")
    @ConditionalOnClass(value={Lock.class})
    @EnableConfigurationProperties(value={LockProperties.class})
    static class DatabaseDistributedLockAutoConfiguration {
        DatabaseDistributedLockAutoConfiguration() {
        }

        @Bean
        @ConditionalOnClass(value={MapperScanBasePackage.class})
        public MapperScanBasePackage lockMapperScanBasePackage() {
            return () -> Collections.singletonList("cn.com.yusys.yusp.commons.lock.impl.db.dao");
        }

        @Bean
        public LockInfoService lockInfoService(LockInfoMapper lockInfoMapper) {
            return new LockInfoService(lockInfoMapper);
        }

        @Bean
        public DistributedLock lockImplDB(LockInfoService lockInfoService, LockProperties lockProperties) {
            return new DatabaseDistributedLock(lockInfoService, lockProperties.getDatabase().getTimeout());
        }
    }
}

