/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.context;

import cn.com.yusys.yusp.commons.autoconfigure.context.DateSpecProperties;
import cn.com.yusys.yusp.commons.util.date.DateDeserializer;
import cn.com.yusys.yusp.commons.util.date.DateFormatUtils;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={JsonSerializer.class, ObjectMapper.class})
@EnableConfigurationProperties(value={DateSpecProperties.class})
public class DateSpecAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DateSpecAutoConfiguration.class);
    private final DateSpecProperties dateSpec;

    public DateSpecAutoConfiguration(DateSpecProperties dateSpec) {
        this.dateSpec = dateSpec;
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer customizerJackson2Object() {
        return jacksonObjectMapperBuilder -> {
            logger.debug("Custom ObjectMapper Date Serializer and Deserializer\u3002");
            DateDeserializer dateSerializer = new DateDeserializer(Date.class, this.dateSpec.getDateFormat(), this.dateSpec.getDateTimeFormat(), this.dateSpec.getZone());
            jacksonObjectMapperBuilder.deserializerByType(Date.class, (JsonDeserializer)dateSerializer);
            jacksonObjectMapperBuilder.serializerByType(Date.class, (JsonSerializer)new DateSerializer(Boolean.valueOf(false), (DateFormat)DateFormatUtils.zone((String)this.dateSpec.getDateTimeFormat(), (String)this.dateSpec.getZone())));
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(this.dateSpec.getDateFormat());
            jacksonObjectMapperBuilder.deserializerByType(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(dateFormatter));
            jacksonObjectMapperBuilder.serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(dateFormatter));
            DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(this.dateSpec.getTimeFormat());
            jacksonObjectMapperBuilder.deserializerByType(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(timeFormatter));
            jacksonObjectMapperBuilder.serializerByType(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(timeFormatter));
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(this.dateSpec.getDateTimeFormat());
            jacksonObjectMapperBuilder.deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(dateTimeFormatter));
            jacksonObjectMapperBuilder.serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormatter));
        };
    }
}

