/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.config.apollo;

import cn.com.yusys.yusp.commons.autoconfigure.config.ConfigAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.config.apollo.ApolloProperties;
import cn.com.yusys.yusp.commons.config.apollo.Apollo;
import cn.com.yusys.yusp.commons.config.apollo.ApolloConfigChangeListenerPostProcessor;
import cn.com.yusys.yusp.commons.config.apollo.ApolloConfigTemplate;
import cn.com.yusys.yusp.commons.config.apollo.CloudConfigChangeListener;
import cn.com.yusys.yusp.commons.config.apollo.ConfigurationPropertiesRefreshListener;
import cn.com.yusys.yusp.commons.config.apollo.OpenApiApolloConfigTemplate;
import cn.com.yusys.yusp.commons.config.core.ConfigTemplate;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.core.dto.ApolloConfig;
import com.ctrip.framework.apollo.openapi.client.ApolloOpenApiClient;
import com.ctrip.framework.apollo.spring.boot.ApolloAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Config.class, ApolloConfigChangeListenerPostProcessor.class})
@AutoConfigureAfter(value={ApolloAutoConfiguration.class})
@EnableConfigurationProperties(value={ApolloProperties.class})
@ConditionalOnProperty(prefix="apollo.bootstrap", name={"enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={ConfigAutoConfiguration.class})
public class YuApolloAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(YuApolloAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public ApolloConfigChangeListenerPostProcessor apolloConfigChangeListenerPostProcessor() {
        log.debug("Load Apollo Config Change Listener BeanPostProcessor");
        return new ApolloConfigChangeListenerPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent"})
    public CloudConfigChangeListener configChangeLister(ApolloProperties apolloProperties) {
        log.debug("Load Apollo Config Change Listener");
        return new CloudConfigChangeListener(apolloProperties.getKeys());
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.context.environment.EnvironmentChangeEvent"})
    public ConfigurationPropertiesRefreshListener configurationPropertiesRefreshListener(RefreshScope refreshScope) {
        return new ConfigurationPropertiesRefreshListener(refreshScope);
    }

    @Bean
    @ConditionalOnClass(value={ApolloOpenApiClient.class, ConfigTemplate.class})
    public ConfigTemplate openApiApolloConfigTemplate(Environment environment) {
        Apollo apollo = Apollo.builder().appId(environment.getProperty("app.id")).env(environment.getProperty("apollo.open-api.env", "DEV")).modifiedBy(environment.getProperty("apollo.open-api.modifiedBy", "apollo")).portalUrl(environment.getProperty("apollo.portal.url", (String)null)).token(environment.getProperty("apollo.open-api.token", (String)null)).build();
        return new OpenApiApolloConfigTemplate(apollo);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={ConfigTemplate.class, ApolloConfig.class})
    public ConfigTemplate apolloConfigTemplate() {
        return new ApolloConfigTemplate();
    }
}

