/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.biz;

import cn.com.yusys.yusp.commons.biz.BizHandlerInterceptor;
import cn.com.yusys.yusp.commons.util.BeanDefinitionUtils;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractBeanFactoryPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Configuration
@ConditionalOnClass(value={BizHandlerInterceptor.class})
public class BizInterceptorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public static BizHandlerInterceptorBeanDefinitionPostProcessor bizHandlerInterceptorBeanDefinitionPostProcessor() {
        return new BizHandlerInterceptorBeanDefinitionPostProcessor();
    }

    static class BizHandlerInterceptorAdvisor
    extends AbstractBeanFactoryPointcutAdvisor {
        BizHandlerInterceptorAdvisor() {
        }

        @NonNull
        public Pointcut getPointcut() {
            return new AnnotationMatchingPointcut(Controller.class, RequestMapping.class, true);
        }
    }

    static class BizHandlerInterceptorBeanDefinitionPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private final Logger log = LoggerFactory.getLogger(BizHandlerInterceptorBeanDefinitionPostProcessor.class);
        private static final String ADVISOR_SUFFIX = "Advisor";

        BizHandlerInterceptorBeanDefinitionPostProcessor() {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            Stream.of(registry.getBeanDefinitionNames()).forEach(beanDefinitionName -> this.addAdvisor(registry, (String)beanDefinitionName));
        }

        void addAdvisor(BeanDefinitionRegistry registry, String beanName) {
            BeanDefinition definition = registry.getBeanDefinition(beanName);
            try {
                if (BeanDefinitionUtils.isAssignFrom((BeanDefinition)definition, BizHandlerInterceptor.class)) {
                    this.log.debug("BizHandlerInterceptor add Advisor in BeanDefinition Registry.");
                    AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(BizHandlerInterceptorAdvisor.class).addPropertyReference("advice", beanName).getBeanDefinition();
                    registry.registerBeanDefinition(beanName + ADVISOR_SUFFIX, (BeanDefinition)beanDefinition);
                }
            }
            catch (ClassNotFoundException e) {
                this.log.error("Cannot find class name.", (Throwable)e);
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

