/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.service.authority.web.filter;

import cn.com.yusys.yusp.commons.service.authority.ServiceAuthority;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.encrypt.AESUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.util.UrlPathHelper;

public class ServiceAuthorityFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ServiceAuthorityFilter.class);
    private UrlPathHelper pathHelper = new UrlPathHelper();
    private AntPathMatcher matcher = new AntPathMatcher();
    private ServiceAuthority serviceAuthority;
    private String serviceName;

    public ServiceAuthorityFilter(String serviceName, ServiceAuthority serviceAuthority) {
        this.serviceName = serviceName;
        this.serviceAuthority = serviceAuthority;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String decryptName;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String appName = request.getHeader("appName");
        boolean isForbidden = false;
        if (StringUtils.nonBlank((CharSequence)appName) && !(decryptName = AESUtils.decrypt((String)appName, (String)"YUSP")).equalsIgnoreCase(this.serviceName)) {
            Map<String, Object> serviceAuthMap = this.serviceAuthority.getAuthRulesByServiceName(this.serviceName.toUpperCase());
            String requestUri = this.pathHelper.getLookupPathForRequest(request);
            if (serviceAuthMap != null) {
                log.info("The request service name is: [{}], and the request route is: [{}]", (Object)decryptName, (Object)requestUri);
                isForbidden = !this.checkServiceAuth(decryptName, requestUri, serviceAuthMap);
            } else {
                log.info("Inter Service Authentication >> there is no authentication rule in the cache, which is forced to be defined as unauthorized! The caller service name is [{}], and the request route is [{}]", (Object)decryptName, (Object)requestUri);
                isForbidden = true;
            }
        }
        if (isForbidden) {
            response.sendError(403, "service forbidden from yusp service filter");
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }

    private boolean checkServiceAuth(String serviceName, String requestUri, Map<String, Object> serviceAuthMap) {
        boolean result = false;
        if (serviceAuthMap != null) {
            String authType = String.valueOf(serviceAuthMap.get("authType"));
            if ("0".equals(authType)) {
                result = true;
            } else if ("1".equals(authType)) {
                List authRuleDTOList = (List)serviceAuthMap.get("serviceAuthRules");
                if (authRuleDTOList != null && !authRuleDTOList.isEmpty()) {
                    for (int i = 0; i < authRuleDTOList.size(); ++i) {
                        String status = String.valueOf(((Map)authRuleDTOList.get(i)).get("status"));
                        String ruleName = String.valueOf(((Map)authRuleDTOList.get(i)).get("ruleName"));
                        if (!"A".equals(status)) continue;
                        List tags = (List)((Map)authRuleDTOList.get(i)).get("tags");
                        int fitTagCount = 0;
                        if (tags == null || tags.isEmpty()) continue;
                        fitTagCount = tags.size();
                        for (int j = 0; j < tags.size(); ++j) {
                            boolean match;
                            boolean inCloud;
                            Map tagMap = (Map)tags.get(j);
                            String tagName = (String)tagMap.get("tagName");
                            String relationType = (String)tagMap.get("relationType");
                            String tagValue = (String)tagMap.get("tagValue");
                            if ("01".equals(tagName)) {
                                boolean match2;
                                if ("01".equals(relationType)) {
                                    if (!serviceName.equalsIgnoreCase(tagValue)) continue;
                                    --fitTagCount;
                                    continue;
                                }
                                if ("02".equals(relationType)) {
                                    if (serviceName.equalsIgnoreCase(tagValue)) continue;
                                    --fitTagCount;
                                    continue;
                                }
                                if ("03".equals(relationType)) {
                                    String[] split = tagValue.split(",");
                                    inCloud = false;
                                    for (String str : split) {
                                        if (!serviceName.equalsIgnoreCase(str)) continue;
                                        inCloud = true;
                                        break;
                                    }
                                    if (!inCloud) continue;
                                    --fitTagCount;
                                    continue;
                                }
                                if ("04".equals(relationType)) {
                                    String[] split = tagValue.split(",");
                                    inCloud = true;
                                    for (String str : split) {
                                        if (!serviceName.equalsIgnoreCase(str)) continue;
                                        inCloud = false;
                                        break;
                                    }
                                    if (!inCloud) continue;
                                    --fitTagCount;
                                    continue;
                                }
                                if (!"05".equals(relationType) || !(match2 = this.matcher.match(tagValue, serviceName))) continue;
                                --fitTagCount;
                                continue;
                            }
                            if ("01".equals(relationType)) {
                                if (!requestUri.equalsIgnoreCase(tagValue)) continue;
                                --fitTagCount;
                                continue;
                            }
                            if ("02".equals(relationType)) {
                                if (requestUri.equalsIgnoreCase(tagValue)) continue;
                                --fitTagCount;
                                continue;
                            }
                            if ("03".equals(relationType)) {
                                String[] split = tagValue.split(",");
                                inCloud = false;
                                for (String str : split) {
                                    if (!requestUri.equalsIgnoreCase(str)) continue;
                                    inCloud = true;
                                    break;
                                }
                                if (!inCloud) continue;
                                --fitTagCount;
                                continue;
                            }
                            if ("04".equals(relationType)) {
                                String[] split = tagValue.split(",");
                                inCloud = true;
                                for (String str : split) {
                                    if (!requestUri.equalsIgnoreCase(str)) continue;
                                    inCloud = false;
                                    break;
                                }
                                if (!inCloud) continue;
                                --fitTagCount;
                                continue;
                            }
                            if (!"05".equals(relationType) || !(match = this.matcher.match(tagValue, requestUri))) continue;
                            --fitTagCount;
                        }
                        if (fitTagCount != 0) continue;
                        log.info("Inter Service Authentication >> in the hit blacklist, the authentication rule named [{}] failed the verification", (Object)ruleName);
                        return false;
                    }
                    result = true;
                } else {
                    result = true;
                }
            } else if ("2".equals(authType)) {
                List authRuleDTOList = (List)serviceAuthMap.get("serviceAuthRules");
                if (authRuleDTOList != null && !authRuleDTOList.isEmpty()) {
                    for (int i = 0; i < authRuleDTOList.size(); ++i) {
                        String status = String.valueOf(((Map)authRuleDTOList.get(i)).get("status"));
                        String ruleName = String.valueOf(((Map)authRuleDTOList.get(i)).get("ruleName"));
                        if (!"A".equals(status)) continue;
                        List tags = (List)((Map)authRuleDTOList.get(i)).get("tags");
                        int fitTagCount = 0;
                        if (tags == null || tags.isEmpty()) continue;
                        fitTagCount = tags.size();
                        for (int j = 0; j < tags.size(); ++j) {
                            boolean match;
                            boolean inCloud;
                            Map tag = (Map)tags.get(j);
                            String tagName = (String)tag.get("tagName");
                            String relationType = (String)tag.get("relationType");
                            String tagValue = (String)tag.get("tagValue");
                            if ("01".equals(tagName)) {
                                boolean match3;
                                if ("01".equals(relationType)) {
                                    if (!serviceName.equalsIgnoreCase(tagValue)) continue;
                                    --fitTagCount;
                                    continue;
                                }
                                if ("02".equals(relationType)) {
                                    if (serviceName.equalsIgnoreCase(tagValue)) continue;
                                    --fitTagCount;
                                    continue;
                                }
                                if ("03".equals(relationType)) {
                                    String[] split = tagValue.split(",");
                                    inCloud = false;
                                    for (String str : split) {
                                        if (!serviceName.equalsIgnoreCase(str)) continue;
                                        inCloud = true;
                                        break;
                                    }
                                    if (!inCloud) continue;
                                    --fitTagCount;
                                    continue;
                                }
                                if ("04".equals(relationType)) {
                                    String[] split = tagValue.split(",");
                                    inCloud = true;
                                    for (String str : split) {
                                        if (!serviceName.equalsIgnoreCase(str)) continue;
                                        inCloud = false;
                                        break;
                                    }
                                    if (!inCloud) continue;
                                    --fitTagCount;
                                    continue;
                                }
                                if (!"05".equals(relationType) || !(match3 = this.matcher.match(tagValue, serviceName))) continue;
                                --fitTagCount;
                                continue;
                            }
                            if ("01".equals(relationType)) {
                                if (!requestUri.equalsIgnoreCase(tagValue)) continue;
                                --fitTagCount;
                                continue;
                            }
                            if ("02".equals(relationType)) {
                                if (requestUri.equalsIgnoreCase(tagValue)) continue;
                                --fitTagCount;
                                continue;
                            }
                            if ("03".equals(relationType)) {
                                String[] split = tagValue.split(",");
                                inCloud = false;
                                for (String str : split) {
                                    if (!requestUri.equalsIgnoreCase(str)) continue;
                                    inCloud = true;
                                    break;
                                }
                                if (!inCloud) continue;
                                --fitTagCount;
                                continue;
                            }
                            if ("04".equals(relationType)) {
                                String[] split = tagValue.split(",");
                                inCloud = true;
                                for (String str : split) {
                                    if (!requestUri.equalsIgnoreCase(str)) continue;
                                    inCloud = false;
                                    break;
                                }
                                if (!inCloud) continue;
                                --fitTagCount;
                                continue;
                            }
                            if (!"05".equals(relationType) || !(match = this.matcher.match(tagValue, requestUri))) continue;
                            --fitTagCount;
                        }
                        if (fitTagCount != 0) continue;
                        log.info("Inter Service Authentication >> in the hit white list, the authentication rule named [{}] passed the verification", (Object)ruleName);
                        return true;
                    }
                    result = false;
                } else {
                    result = false;
                }
            }
        }
        return result;
    }
}

