/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.validation.util;

import cn.com.yusys.yusp.commons.validation.ValidateException;
import cn.com.yusys.yusp.commons.validation.ValueInfo;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidator;
import java.util.Collection;
import java.util.HashSet;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ValidatorUtils {
    static Validator instance = null;

    public static Validator getHibernateValidator() {
        if (null == instance) {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            instance = factory.getValidator();
        }
        return instance;
    }

    public static void validate(Object validatedObj, Class<?> ... groups) {
        if (validatedObj instanceof Collection) {
            ValidatorUtils.validate((Collection)validatedObj, groups);
        } else {
            ValidatorUtils.validate(validatedObj, "", groups);
        }
    }

    private static void validate(Object validatedObj, String prefix, Class<?> ... groups) {
        BeanValidator v;
        if (null == validatedObj) {
            return;
        }
        try {
            BeanValidator.init(ValidatorUtils.getHibernateValidator());
            v = BeanValidator.create(validatedObj.getClass());
        }
        catch (Exception e) {
            Throwable cause = e;
            if (cause instanceof ExceptionInInitializerError) {
                cause = cause.getCause();
            }
            throw new ValidateException("\u521b\u5efa\u62a5\u6587\u6570\u636e\u68c0\u9a8c\u5668\u5931\u8d25:" + validatedObj.getClass().getName(), cause);
        }
        v.validate(validatedObj, prefix, new HashSet(), groups);
    }

    private static void validate(Collection<?> validatedObjs, Class<?> ... groups) {
        if (validatedObjs.isEmpty()) {
            return;
        }
        BeanValidator v = null;
        Class<?> itemClass = null;
        int idx = 0;
        BeanValidator.init(ValidatorUtils.getHibernateValidator());
        for (Object obj : validatedObjs) {
            if (obj == null) continue;
            if (!obj.getClass().equals(itemClass)) {
                itemClass = obj.getClass();
                try {
                    v = BeanValidator.create(itemClass);
                }
                catch (Exception e) {
                    Throwable cause = e;
                    if (cause instanceof ExceptionInInitializerError) {
                        cause = cause.getCause();
                    }
                    throw new ValidateException("\u521b\u5efa\u62a5\u6587\u6570\u636e\u68c0\u9a8c\u5668\u5931\u8d25:" + itemClass.getName(), cause);
                }
            }
            String prefix = "[" + Integer.toString(idx) + "].";
            v.validate(obj, prefix, new HashSet(), groups);
            ++idx;
        }
    }

    public static ValueInfo getCurrentValueInfo() {
        return BeanValidator.getCurrentBean();
    }

    private ValidatorUtils() {
    }
}

