/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.validation.annoation;

import cn.com.yusys.yusp.commons.validation.util.CheckUtils;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.LocalDate;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={Checker.class})
@Documented
public @interface DateRange {
    public String message() default "{cn.com.yusys.yusp.commons.validation.annoation.DateRange.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String lt() default "9999-12-31";

    public String gt() default "1970-01-01";

    public String le() default "9999-12-31";

    public String ge() default "1970-01-01";

    public static class Checker
    implements ConstraintValidator<DateRange, String> {
        private static final String CURRENT_DATE = "currentDate";
        String lt = null;
        String gt = null;
        String le = null;
        String ge = null;

        public void initialize(DateRange ann) {
            this.lt = this.getCurrentDate(ann.lt());
            this.gt = this.getCurrentDate(ann.gt());
            this.le = this.getCurrentDate(ann.le());
            this.ge = this.getCurrentDate(ann.ge());
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            if (null == value) {
                return true;
            }
            LocalDate currentValue = CheckUtils.getDate(value);
            LocalDate ltValue = CheckUtils.getDate(this.lt);
            LocalDate gtValue = CheckUtils.getDate(this.gt);
            LocalDate leValue = CheckUtils.getDate(this.le);
            LocalDate geValue = CheckUtils.getDate(this.ge);
            return currentValue.compareTo(ltValue) < 0 && currentValue.compareTo(gtValue) > 0 && currentValue.compareTo(leValue) <= 0 && currentValue.compareTo(geValue) >= 0;
        }

        private String getCurrentDate(String configValue) {
            if (CURRENT_DATE.equals(configValue)) {
                return CheckUtils.getCurrentDate();
            }
            return configValue;
        }
    }
}

