/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.web.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

public class FileUploadCheckFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(FileUploadCheckFilter.class);
    private List<String> defaultFileTypes = Arrays.asList("docx", "doc", "xlsx", "xls", "txt", "jpg", "png", "pdf", "zip", "rar");

    public FileUploadCheckFilter(List<String> fileType) {
        if (fileType != null && !fileType.isEmpty()) {
            this.defaultFileTypes = fileType.parallelStream().filter(Objects::nonNull).map(String::trim).collect(Collectors.toList());
        }
        log.info("The configured file whitelist is: {}", this.defaultFileTypes);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        StandardServletMultipartResolver standardServletMultipartResolver = new StandardServletMultipartResolver();
        if (log.isDebugEnabled()) {
            log.debug("Enter file upload filter");
        }
        if (standardServletMultipartResolver.isMultipart(request)) {
            if (log.isDebugEnabled()) {
                log.debug("File upload url\uff1a{}", (Object)request.getRequestURI());
            }
            MultipartHttpServletRequest multiRequest = standardServletMultipartResolver.resolveMultipart(request);
            Map files = multiRequest.getFileMap();
            for (Map.Entry entry : files.entrySet()) {
                String fileName = ((MultipartFile)entry.getValue()).getOriginalFilename();
                String suffix = fileName.substring(fileName.lastIndexOf(46) + 1);
                if (!this.defaultFileTypes.contains(suffix.toLowerCase())) {
                    log.debug("not support file type, file name [{}] upload url\uff1a{}", (Object)fileName, (Object)request.getRequestURI());
                    response.sendError(500, "file type not supported");
                    return;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Legal file upload url\uff1a{}", (Object)request.getRequestURI());
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

