/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.openfeign.mock.store.impl;

import cn.com.yusys.yusp.commons.openfeign.exception.FeignInvokeException;
import cn.com.yusys.yusp.commons.openfeign.mock.store.MockData;
import cn.com.yusys.yusp.commons.openfeign.mock.store.MockDataStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.bind.annotation.RequestMethod;

public class MapMockDataStore
implements MockDataStore {
    private Map<String, List<MockData<?>>> mockDataMap = new ConcurrentHashMap();

    @Override
    public int store(List<MockData<?>> mockDataList) {
        int num = 0;
        for (MockData<?> mockData : mockDataList) {
            String url = mockData.getUrl();
            this.mockDataMap.computeIfAbsent(url, k -> new ArrayList());
            this.mockDataMap.get(url).add(mockData);
            ++num;
        }
        return num;
    }

    @Override
    public List<MockData<?>> findByUrl(String url) {
        return this.mockDataMap.get(url);
    }

    @Override
    public MockData<?> findOneByUrl(String url, RequestMethod method) {
        List<MockData<?>> mockDataList = this.findByUrl(url);
        if (mockDataList == null || mockDataList.isEmpty()) {
            throw new FeignInvokeException(String.format("URL: %s, mock data not exists", url));
        }
        Optional<MockData> mockDataOptional = mockDataList.stream().filter(mockData -> mockData.getMethod().equals((Object)method)).findFirst();
        return mockDataOptional.orElse(null);
    }

    @Override
    public int deleteMocks(List<String> urlList) {
        return urlList.stream().mapToInt(url -> this.mockDataMap.remove(url) == null ? 0 : 1).sum();
    }

    @Override
    public int deleteAll() {
        int size = this.mockDataMap.size();
        this.mockDataMap.clear();
        return size;
    }
}

