/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.openfeign.interceptor;

import cn.com.yusys.yusp.commons.openfeign.exception.FeignInvokeException;
import cn.com.yusys.yusp.commons.openfeign.interceptor.FeignInterceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;

public class Plugin
implements InvocationHandler {
    private final Object target;
    private final FeignInterceptor interceptor;

    private Plugin(Object target, FeignInterceptor interceptor) {
        this.target = target;
        this.interceptor = interceptor;
    }

    public static Object wrap(Object target, FeignInterceptor interceptor) {
        Class<?> type = target.getClass();
        Class<?>[] interfaces = Plugin.getAllInterfaces(type);
        if (interfaces.length > 0) {
            return Proxy.newProxyInstance(type.getClassLoader(), interfaces, (InvocationHandler)new Plugin(target, interceptor));
        }
        return target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws FeignInvokeException {
        try {
            return this.interceptor.intercept(this.target, method, args);
        }
        catch (Exception e) {
            throw new FeignInvokeException("Feign invoke exception:", e);
        }
    }

    private static Class<?>[] getAllInterfaces(Class<?> type) {
        HashSet interfaces = new HashSet();
        while (type != null) {
            interfaces.addAll(Arrays.asList(type.getInterfaces()));
            type = type.getSuperclass();
        }
        return interfaces.toArray(new Class[0]);
    }
}

