/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt.crypto.symmetric;

import cn.com.yusys.yusp.commons.util.encrypt.crypto.Mode;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.Padding;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.SecureUtils;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.symmetric.SymmetricAlgorithm;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.symmetric.SymmetricCrypto;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class DES
extends SymmetricCrypto {
    private static final long serialVersionUID = 1L;

    public DES() {
        super(SymmetricAlgorithm.DES);
    }

    public DES(byte[] key) {
        super(SymmetricAlgorithm.DES, key);
    }

    public DES(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public DES(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public DES(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public DES(String mode, String padding, byte[] key) {
        this(mode, padding, SecureUtils.generateKey("DES", key), null);
    }

    public DES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, SecureUtils.generateKey("DES", key), null == iv ? null : new IvParameterSpec(iv));
    }

    public DES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(String.format("DES/%s/%s", mode, padding), key, iv);
    }
}

