/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt;

import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.commons.util.encrypt.Base64;
import cn.com.yusys.yusp.commons.util.encrypt.SM4;
import cn.com.yusys.yusp.commons.util.encrypt.SM4Context;
import cn.com.yusys.yusp.commons.util.exception.UtilRuntimeException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SM4Utils {
    public static final String SM4_ENCRYPTION_FAILED = "SM4 encryption failed";
    private static final String PATTERN = "\\s*|\t|\r|\n";

    private SM4Utils() {
    }

    public static String encryptDataECB(String secretKey, String data, String enCoding, boolean hexString) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = hexString ? NumberUtils.hexToByte(secretKey) : secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4SetkeyEnc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4CryptEcb(ctx, data.getBytes(enCoding));
            String cipherText = Base64.encodeBase64String(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile(PATTERN);
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            throw new UtilRuntimeException(SM4_ENCRYPTION_FAILED, e);
        }
    }

    public static String decryptDataECB(String secretKey, String data, String enCoding, boolean hexString) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = hexString ? NumberUtils.hexToByte(secretKey) : secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4SetkeyDec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4CryptEcb(ctx, Base64.decodeBase64(data));
            return new String(decrypted, enCoding);
        }
        catch (Exception e) {
            throw new UtilRuntimeException("SM4 decryption failed", e);
        }
    }

    public static String encryptDataCBC(String secretKey, String iv, String data, String enCoding, boolean hexString) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (hexString) {
                keyBytes = NumberUtils.hexToByte(secretKey);
                ivBytes = NumberUtils.hexToByte(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4SetkeyEnc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4CryptCbc(ctx, ivBytes, data.getBytes(enCoding));
            String cipherText = Base64.encodeBase64String(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile(PATTERN);
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            throw new UtilRuntimeException(SM4_ENCRYPTION_FAILED, e);
        }
    }

    public static String decryptDataCBC(String secretKey, String iv, String data, String enCoding, boolean hexString) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (hexString) {
                keyBytes = NumberUtils.hexToByte(secretKey);
                ivBytes = NumberUtils.hexToByte(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4SetkeyDec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4CryptCbc(ctx, ivBytes, Base64.decodeBase64(data));
            return new String(decrypted, enCoding);
        }
        catch (Exception e) {
            throw new UtilRuntimeException("SM4 decryption failed", e);
        }
    }
}

