/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt;

import cn.com.yusys.yusp.commons.util.encrypt.Base64;
import cn.com.yusys.yusp.commons.util.exception.UtilRuntimeException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class AESUtils {
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final String AES_CIPHER_ALGORITHM = "AES/GCM/NoPadding";

    private AESUtils() {
    }

    public static String encrypt(String content, String key) {
        return AESUtils.encrypt(content, StandardCharsets.UTF_8.name(), key);
    }

    public static String encrypt(String content, String charset, String key) {
        try {
            return Base64.encodeBase64String(AESUtils.encrypt(content.getBytes(charset), key));
        }
        catch (Exception ex) {
            throw new UtilRuntimeException(ex.getMessage(), ex);
        }
    }

    public static byte[] encrypt(byte[] content, String key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, AESUtils.getSecretKey(key));
            return cipher.doFinal(content);
        }
        catch (Exception ex) {
            throw new UtilRuntimeException(ex.getMessage(), ex);
        }
    }

    public static String encryptAes(String content, String key) {
        return AESUtils.encryptAes(content, StandardCharsets.UTF_8.name(), key);
    }

    public static String encryptAes(String content, String charset, String key) {
        try {
            return Base64.encodeBase64String(AESUtils.encryptAes(content.getBytes(charset), key));
        }
        catch (Exception ex) {
            throw new UtilRuntimeException(ex.getMessage(), ex);
        }
    }

    public static byte[] encryptAes(byte[] content, String key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, AESUtils.getSecretKey(key));
            return cipher.doFinal(content);
        }
        catch (Exception ex) {
            throw new UtilRuntimeException(ex.getMessage(), ex);
        }
    }

    public static String decrypt(String content, String key) {
        return AESUtils.decrypt(content, StandardCharsets.UTF_8.name(), key);
    }

    public static byte[] decrypt(byte[] content, String key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, AESUtils.getSecretKey(key));
            return cipher.doFinal(content);
        }
        catch (Exception ex) {
            throw new UtilRuntimeException(ex.getMessage(), ex);
        }
    }

    public static String decrypt(String content, String charset, String key) {
        try {
            return new String(AESUtils.decrypt(Base64.decodeBase64(content), key), charset);
        }
        catch (Exception e) {
            throw new UtilRuntimeException(e.getMessage(), e);
        }
    }

    public static String decryptAes(String content, String key) {
        return AESUtils.decryptAes(content, StandardCharsets.UTF_8.name(), key);
    }

    public static String decryptAes(String content, String charset, String key) {
        try {
            return new String(AESUtils.decryptAes(Base64.decodeBase64(content), key), charset);
        }
        catch (Exception ex) {
            throw new UtilRuntimeException(ex.getMessage(), ex);
        }
    }

    public static byte[] decryptAes(byte[] content, String key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, AESUtils.getSecretKey(key));
            return cipher.doFinal(content);
        }
        catch (Exception ex) {
            throw new UtilRuntimeException(ex.getMessage(), ex);
        }
    }

    private static SecretKeySpec getSecretKey(String key) {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(KEY_ALGORITHM);
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(key.getBytes());
            kg.init(128, random);
            SecretKey secretKey = kg.generateKey();
            return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
        }
        catch (Exception ex) {
            throw new UtilRuntimeException(ex.getMessage(), ex);
        }
    }
}

