/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.date;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateFormatUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateDeserializer
extends StdDeserializer<Date> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DateDeserializer.class);
    private final String dateFormat;
    private final String dateTimeFormat;
    private final String zone;

    public DateDeserializer(Class<?> clazz, String dateFormat, String dateTimeFormat, String zone) {
        super(clazz);
        this.dateFormat = dateFormat;
        this.dateTimeFormat = dateTimeFormat;
        this.zone = zone;
    }

    public Date deserialize(JsonParser p, DeserializationContext context) throws IOException {
        String value = null;
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            value = p.getText().trim();
        }
        if (StringUtils.isEmpty(value)) {
            return (Date)this.getEmptyValue(context);
        }
        value = value.trim();
        try {
            if (value.contains("-")) {
                SimpleDateFormat formatter = value.contains(":") ? DateFormatUtils.zone(this.dateTimeFormat, this.zone) : DateFormatUtils.zone(this.dateFormat, this.zone);
                return formatter.parse(value);
            }
            if (value.matches(DateFormatEnum.TIMESTAMP.getValue())) {
                return new Date(Long.parseLong(value));
            }
        }
        catch (ParseException e) {
            logger.warn("Parse Date param exception.");
        }
        return (Date)context.handleWeirdStringValue(this.handledType(), value, "expected format %s or %s", new Object[]{DateFormatEnum.DEFAULT.getValue(), DateFormatEnum.DATETIME});
    }
}

