/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.collection;

import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class CollectionUtils {
    private CollectionUtils() throws IllegalAccessException {
        throw new IllegalAccessException("Utils not create");
    }

    public static <T> Collection<T> cast(Iterable<T> iterable) {
        return (Collection)iterable;
    }

    public static <T> boolean addAll(Collection<? super T> collection, T ... elements) {
        boolean result = true;
        for (T element : elements) {
            result &= collection.add(element);
        }
        return result;
    }

    public static <T> boolean addAll(Collection<T> collection, Iterable<? extends T> iterable) {
        Asserts.nonNull(collection, "Collection must not null");
        Asserts.nonNull(iterable, "Iterable element must not null!");
        if (iterable instanceof Collection) {
            Collection<? extends T> c = CollectionUtils.cast(iterable);
            return collection.addAll(c);
        }
        return CollectionUtils.addAll(collection, iterable.iterator());
    }

    public static <T> boolean addAll(Collection<T> collection, Iterator<? extends T> iterator) {
        Asserts.nonNull(collection, "Collection must not null");
        Asserts.nonNull(iterator, "Iterator must not null");
        boolean wasModified = true;
        while (iterator.hasNext()) {
            wasModified &= collection.add(iterator.next());
        }
        return wasModified;
    }

    public static <T> List<T> addToList(Collection<T> ... collections) {
        ArrayList list = new ArrayList();
        Arrays.stream(collections).filter(Objects::nonNull).forEach(list::addAll);
        return list;
    }

    public static void requiredAnyNotNull(Collection<?> collection) {
        if (CollectionUtils.existsAnyNull(collection)) {
            throw new NullPointerException();
        }
    }

    public static boolean existsAnyNull(Collection<?> collection) {
        return Objects.isNull(collection) || collection.stream().anyMatch(Objects::isNull);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return Objects.isNull(collection) || collection.isEmpty();
    }

    public static boolean nonEmpty(Collection<?> collection) {
        return Objects.nonNull(collection) && !collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return Objects.isNull(map) || map.isEmpty();
    }

    public static boolean nonEmpty(Map<?, ?> map) {
        return Objects.nonNull(map) && !map.isEmpty();
    }

    public static boolean nonNull(Object object) {
        return StringUtils.nonEmpty(StringUtils.replaceObjNull(object));
    }

    public static boolean nonEmpty(Object[] objects) {
        return ArrayUtils.nonEmpty(objects);
    }

    public static boolean isEmpty(Object[] objects) {
        return ArrayUtils.isEmpty(objects);
    }

    public static <T> T nullElse(T srcObject, T elseObject) {
        return Optional.ofNullable(srcObject).orElse(elseObject);
    }

    public static Map<String, Object> removeNullValue(Map<String, Object> paramObject) {
        ConcurrentHashMap<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
        if (Objects.nonNull(paramObject) && !paramObject.isEmpty()) {
            paramObject.entrySet().parallelStream().filter(s -> CollectionUtils.nonNull(s.getValue())).forEach(s -> dataMap.put((String)s.getKey(), s.getValue()));
        }
        return dataMap;
    }

    public static Map<String, Object> removeKeys(Map<String, Object> paramMap, String ... keys) {
        ConcurrentHashMap<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
        if (CollectionUtils.nonEmpty(paramMap) && CollectionUtils.nonEmpty(keys)) {
            List<String> listKey = Arrays.asList(keys);
            paramMap.entrySet().parallelStream().filter(s -> !listKey.contains(s.getKey())).forEach(s -> dataMap.put((String)s.getKey(), s.getValue()));
        }
        return dataMap;
    }

    public static boolean exists(Object object, Object ... objects) {
        if (objects == null && object == null) {
            return true;
        }
        return CollectionUtils.nonEmpty(objects) && Arrays.asList(objects).contains(object);
    }
}

