/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.RegExpTypes;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExpUtils {
    private static final Pattern MATCH_IP_PATTERN = Pattern.compile(RegExpTypes.IP.getValue());
    private static final Pattern MATCH_IP_V4_PATTERN = Pattern.compile(RegExpTypes.IP_V4.getValue());
    private static final Pattern MATCH_IP_V6_PATTERN = Pattern.compile(RegExpTypes.IP_V6.getValue());
    private static final Pattern MATCH_FIXED_PHONE_PATTERN = Pattern.compile(RegExpTypes.FIXED_PHONE.getValue());
    private static final Pattern MATCH_MOBILE_PHONE_PATTERN = Pattern.compile(RegExpTypes.MOBILE_PHONE.getValue());
    private static final Pattern MATCH_NUMBER_PATTERN = Pattern.compile(RegExpTypes.NUMBER.getValue());
    private static final Pattern MATCH_CHINESE_PATTERN = Pattern.compile(RegExpTypes.CHINESE.getValue());
    private static final Pattern MATCH_E_MAIL_PATTERN = Pattern.compile(RegExpTypes.E_MAIL.getValue());
    private static final Pattern MATCH_DNS_PATTERN = Pattern.compile(RegExpTypes.DNS.getValue());
    private static final Pattern MATCH_URI_PATTERN = Pattern.compile(RegExpTypes.URI.getValue());
    private static final Pattern MATCH_URL_PATTERN = Pattern.compile(RegExpTypes.URL.getValue());
    public static final Pattern HEX = Pattern.compile("^[a-f0-9]+$", 2);

    private RegExpUtils() {
    }

    public static boolean match(RegExpTypes type, String string) {
        return !Objects.isNull(string) && !string.isEmpty() && Pattern.matches("^" + type.getValue() + "$", string);
    }

    public static boolean has(RegExpTypes type, String string) {
        return !Objects.isNull(string) && !string.isEmpty() && RegExpUtils.getPattern(type).matcher(string).find();
    }

    public static boolean allMatch(RegExpTypes type, String ... strings) {
        if (Objects.isNull(strings) || strings.length == 0) {
            return false;
        }
        for (String string : strings) {
            if (RegExpUtils.match(type, string)) continue;
            return false;
        }
        return true;
    }

    public static boolean allMatch(RegExpTypes type, List<String> stringList) {
        if (Objects.isNull(stringList) || stringList.isEmpty()) {
            return false;
        }
        for (String string : stringList) {
            if (RegExpUtils.match(type, string)) continue;
            return false;
        }
        return true;
    }

    public static List<String> all(RegExpTypes type, String text, boolean isExtract) {
        Matcher m;
        ArrayList<String> result = new ArrayList<String>();
        if (Objects.isNull(text)) {
            return result;
        }
        Matcher matcher = m = isExtract ? RegExpUtils.getPattern(type).matcher(text) : Pattern.compile("^" + type.getValue() + "$").matcher(text);
        while (m.find()) {
            result.add(m.group(0));
        }
        return result;
    }

    public static List<String> all(RegExpTypes type, boolean isExtract, String ... strings) {
        if (Objects.isNull(strings) || strings.length == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String string : strings) {
            result.addAll(RegExpUtils.all(type, string, isExtract));
        }
        return result;
    }

    public static List<String> all(RegExpTypes type, List<String> stringList, boolean isExtract) {
        if (Objects.isNull(stringList) || stringList.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        stringList.forEach(string -> result.addAll(RegExpUtils.all(type, string, isExtract)));
        return result;
    }

    public static String first(RegExpTypes type, String text) {
        if (Objects.isNull(text)) {
            return null;
        }
        Matcher m = RegExpUtils.getPattern(type).matcher(text);
        if (m.find()) {
            return m.group(0);
        }
        return null;
    }

    public static String last(RegExpTypes type, String text) {
        if (Objects.isNull(text)) {
            return null;
        }
        List<String> list = RegExpUtils.all(type, text, true);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    private static Pattern getPattern(RegExpTypes type) {
        switch (type) {
            case IP: {
                return MATCH_IP_PATTERN;
            }
            case IP_V4: {
                return MATCH_IP_V4_PATTERN;
            }
            case IP_V6: {
                return MATCH_IP_V6_PATTERN;
            }
            case FIXED_PHONE: {
                return MATCH_FIXED_PHONE_PATTERN;
            }
            case MOBILE_PHONE: {
                return MATCH_MOBILE_PHONE_PATTERN;
            }
            case NUMBER: {
                return MATCH_NUMBER_PATTERN;
            }
            case CHINESE: {
                return MATCH_CHINESE_PATTERN;
            }
            case E_MAIL: {
                return MATCH_E_MAIL_PATTERN;
            }
            case DNS: {
                return MATCH_DNS_PATTERN;
            }
            case URI: {
                return MATCH_URI_PATTERN;
            }
            case URL: {
                return MATCH_URL_PATTERN;
            }
        }
        return Pattern.compile(type.getValue());
    }

    public static boolean isMatch(String regex, CharSequence content) {
        if (content == null) {
            return false;
        }
        if (StringUtils.isEmpty(regex)) {
            return true;
        }
        Pattern pattern = Pattern.compile(regex, 32);
        return RegExpUtils.isMatch(pattern, content);
    }

    public static boolean isMatch(Pattern pattern, CharSequence content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }
}

