/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import java.security.SecureRandom;
import java.util.concurrent.ThreadLocalRandom;

public final class RandomUtils {
    private RandomUtils() {
    }

    public static SecureRandom createSecureRandom(byte[] seed) {
        return null == seed ? new SecureRandom() : new SecureRandom(seed);
    }

    public static String getRandom(int length) {
        try {
            String random = String.valueOf(SecureRandom.getInstance("SHA1PRNG").nextInt());
            return random.substring(random.length() - length);
        }
        catch (Exception err) {
            double r = Math.random();
            while (length-- > 0) {
                r *= 10.0;
            }
            return String.valueOf((int)r);
        }
    }

    public static String randomString(int length) {
        StringBuilder randomCode = new StringBuilder();
        StringBuilder fixedString = new StringBuilder("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (randomCode.length() < length) {
            int index = random.nextInt(fixedString.length());
            randomCode.append(fixedString.charAt(index));
        }
        return randomCode.toString();
    }

    public static int nextInt(int origin, int bound) {
        return ThreadLocalRandom.current().nextInt(origin, bound);
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }
}

