/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.springframework.util.AntPathMatcher;

public abstract class Predicates {
    private static final AntPathMatcher matcher = new AntPathMatcher();

    public static <T> Predicate<T> alwaysTrue() {
        return input -> true;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return input -> false;
    }

    public static Predicate<String> regex(String pathRegex) {
        return input -> input.matches(pathRegex);
    }

    public static Predicate<String> ant(String antPattern) {
        return input -> matcher.match(antPattern, input);
    }

    @SafeVarargs
    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        ArrayUtils.requiredAnyNotNUll(components);
        return input -> Arrays.stream(components).anyMatch(c -> c.test(input));
    }

    public static <T> Predicate<T> or(Collection<Predicate<T>> components) {
        CollectionUtils.requiredAnyNotNull(components);
        return input -> components.stream().anyMatch(c -> c.test(input));
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        ArrayUtils.requiredAnyNotNUll(components);
        return input -> Arrays.stream(components).allMatch(c -> c.test(input));
    }
}

