/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Objects;

public class BooleanUtils {
    private static String[] TRUE_ARRAY = new String[]{"true", "yes", "y", "t", "ok", "1", "on", "\u662f", "\u5bf9", "\u771f"};

    private BooleanUtils() {
    }

    public static Boolean negate(Boolean bool) {
        return Objects.nonNull(bool) ? (bool.booleanValue() ? Boolean.FALSE : Boolean.TRUE) : null;
    }

    public static boolean negate(boolean bool) {
        return !bool;
    }

    public static boolean isTrue(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public static boolean isFalse(Boolean bool) {
        return Boolean.FALSE.equals(bool);
    }

    public static boolean toBoolean(String str) {
        if (StringUtils.nonBlank(str)) {
            str = str.trim().toLowerCase();
            return ArrayUtils.contains(TRUE_ARRAY, str);
        }
        return false;
    }

    public static int toInt(boolean bool) {
        return bool ? 1 : 0;
    }

    public static Integer toInteger(boolean bool) {
        return BooleanUtils.toInt(bool);
    }

    public static char toChar(boolean bool) {
        return (char)BooleanUtils.toInt(bool);
    }

    public static char toCharacter(boolean bool) {
        return BooleanUtils.toChar(bool);
    }

    public static byte toByte(boolean bool) {
        return (byte)BooleanUtils.toInt(bool);
    }

    public static byte toByteObj(boolean bool) {
        return BooleanUtils.toByte(bool);
    }

    public static long toLong(boolean bool) {
        return BooleanUtils.toInt(bool);
    }

    public static Long toLongObj(boolean bool) {
        return BooleanUtils.toLong(bool);
    }

    public static short toShort(boolean bool) {
        return (short)BooleanUtils.toInt(bool);
    }

    public static Short toShortObj(boolean bool) {
        return BooleanUtils.toShort(bool);
    }

    public static float toFloat(boolean bool) {
        return BooleanUtils.toInt(bool);
    }

    public static Float toFloatObj(boolean bool) {
        return Float.valueOf(BooleanUtils.toFloat(bool));
    }

    public static double toDouble(boolean bool) {
        return BooleanUtils.toInt(bool);
    }

    public static Double toDoubleObj(boolean bool) {
        return BooleanUtils.toDouble(bool);
    }

    public static boolean and(boolean ... array) {
        for (boolean bool : array) {
            if (bool) continue;
            return false;
        }
        return true;
    }

    public static Boolean and(Boolean ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] primitive = ArrayUtils.unwrap(array);
        return BooleanUtils.and(primitive);
    }

    public static boolean or(boolean ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean element : array) {
            if (!element) continue;
            return true;
        }
        return false;
    }

    public static Boolean or(Boolean ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] primitive = ArrayUtils.unwrap(array);
        return BooleanUtils.or(primitive);
    }

    public static boolean xor(boolean ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty");
        }
        boolean result = false;
        for (boolean element : array) {
            result ^= element;
        }
        return result;
    }

    public static Boolean xor(Boolean ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] primitive = ArrayUtils.unwrap(array);
        return BooleanUtils.xor(primitive);
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }
}

