/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.async;

import cn.com.yusys.yusp.commons.excelcsv.async.I18nAsyncTask;
import cn.com.yusys.yusp.commons.excelcsv.async.ImportContext;
import cn.com.yusys.yusp.commons.excelcsv.async.Visitor;
import cn.com.yusys.yusp.commons.excelcsv.model.ProgressDto;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.File;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportAsyncTask
extends I18nAsyncTask {
    private static final Logger logger = LoggerFactory.getLogger(ImportAsyncTask.class);
    private final ProgressDto progressDto;
    private final ImportContext importContext;

    public ImportAsyncTask(ImportContext importContext) {
        Asserts.nonEmpty((CharSequence)importContext.getFile(), (String[])new String[]{"Import file must not empty!"});
        this.importContext = importContext;
        this.progressDto = ProgressDto.of(StringUtils.uuid((boolean)false));
    }

    @Override
    public void doRun() {
        try {
            this.importContext.getProgress().set(this.progressDto.getTaskId(), this.progressDto);
            if (this.importContext.isGlobalTx() && Objects.nonNull(this.importContext.getTransaction())) {
                logger.info("async task\uff1a{}, file: {} execute start transaction!", (Object)this.progressDto.getTaskId(), (Object)this.importContext.getFile());
                this.importContext.getTransaction().execute(this::readAndImport);
                logger.info("async task\uff1a{}, file: {} execute end transaction!", (Object)this.progressDto.getTaskId(), (Object)this.importContext.getFile());
            } else {
                this.readAndImport();
            }
            logger.info("async task\uff1a{}, file:{} import finished.", (Object)this.progressDto.getTaskId(), (Object)this.importContext.getFile());
            this.progressDto.setProgressBar(100);
            this.importContext.getProgress().set(this.progressDto.getTaskId(), this.progressDto);
        }
        catch (Throwable e) {
            logger.error("async task\uff1a" + this.progressDto.getTaskId() + ", file:" + this.importContext.getFile() + " import occur error!", e);
            this.progressDto.setProgressBar(-1);
            this.importContext.getProgress().set(this.progressDto.getTaskId(), this.progressDto);
        }
        finally {
            File file;
            if (this.importContext.getFile() != null && (file = new File(this.importContext.getFile())).exists() && file.delete()) {
                logger.info("file:[{}] delete success!", (Object)this.importContext.getFile());
            }
        }
    }

    public void readAndImport() {
        File file = new File(this.importContext.getFile());
        this.importContext.getExporterImporter().importData(this.importContext.getHeadClass(), file, this.importContext.getDataHandle(), this.importContext.getDataStorageHandler(), new SizeCalcVisitor(file.length(), 99, percentage -> {
            this.progressDto.setProgressBar((int)percentage);
            this.importContext.getProgress().set(this.progressDto.getTaskId(), this.progressDto);
        }));
        if (this.importContext.isBatch()) {
            this.importContext.getDataStorageHandler().accept(null);
        }
    }

    public ProgressDto getProgressDto() {
        return this.progressDto;
    }

    static class SizeCalcVisitor
    implements Visitor<Object> {
        private final long fileSize;
        private final int loopCalcLimit = 100;
        private final Consumer<Integer> afterProcessor;
        private long objectSize = -1L;
        private int maxPercentage = 100;
        private int loopNum = 0;

        public SizeCalcVisitor(long fileSize, int maxPercentage, Consumer<Integer> afterProcessor) {
            this.fileSize = fileSize;
            this.afterProcessor = afterProcessor;
            this.maxPercentage = maxPercentage;
        }

        @Override
        public void visit(Object o) {
            if (this.objectSize < 0L && o != null) {
                int size = ObjectMapperUtils.toJson((Object)o).getBytes().length;
                this.objectSize = size > 0 ? (long)size : -1L;
            }
            ++this.loopNum;
            if (this.loopNum % 100 == 0) {
                int percentage = Math.min((int)(this.objectSize / this.fileSize), this.maxPercentage);
                this.afterProcessor.accept(percentage);
            }
        }
    }
}

