/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.ITemplate;
import cn.com.yusys.yusp.commons.excelcsv.async.Visitor;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.excelcsv.handle.HeadProperty;
import cn.com.yusys.yusp.commons.excelcsv.util.RecordInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CsvTemplate
implements ITemplate {
    private static final Logger logger = LoggerFactory.getLogger(CsvTemplate.class);
    public static final String COMMA = ",";
    private static final String LF = "\n";
    private final Class<?> headClass;
    private final DataHandle dataHandle;
    private final HeadProperty headProperty;
    private final String delimiter;

    public CsvTemplate(Class<?> headClass, DataHandle dataHandle) {
        this(headClass, dataHandle, COMMA);
    }

    public CsvTemplate(Class<?> headClass, DataHandle dataHandle, String delimiter) {
        Objects.requireNonNull(headClass, "head class can not be null.");
        Objects.requireNonNull(dataHandle, "dataHandle can not be null.");
        this.headClass = headClass;
        this.dataHandle = dataHandle;
        this.headProperty = this.dataHandle.analysisHead(headClass);
        this.delimiter = delimiter.isEmpty() ? COMMA : delimiter;
    }

    @Override
    public void export(Object model, File outFile) {
        Iterable<?> records = this.getIterableRecords(model);
        RecordInfo recordInfo = RecordInfo.of(this.headClass, this.headProperty.getNotIgnoreHeadInfos());
        if (this.delimiter.length() > 1) {
            this.exportWithSpecSplit(records, recordInfo, outFile);
        } else {
            this.exportWithSingleSplit(records, recordInfo, outFile);
        }
    }

    private Iterable<?> getIterableRecords(Object model) {
        Iterable<Object> records = model.getClass().isArray() ? CollectionUtils.arrayToList((Object)model) : (model instanceof Map ? ((Map)model).values() : (model instanceof Iterable ? (Iterable)model : Collections.singletonList(model)));
        return records;
    }

    private void exportWithSingleSplit(Iterable<?> records, RecordInfo recordInfo, File outFile) {
        CSVFormat csvFormat = COMMA.equals(this.delimiter) ? CSVFormat.EXCEL : CSVFormat.newFormat((char)this.delimiter.charAt(0)).withIgnoreEmptyLines().withRecordSeparator(LF);
        try (CSVPrinter csvPrinter = csvFormat.withHeader(recordInfo.getFieldTitles()).print(outFile, StandardCharsets.UTF_8);){
            for (Object record : records) {
                if ((record = this.dataHandle.handle(record, DataHandle.OperationType.EXPORT)) == null) {
                    logger.warn("return null value after custom handle while export csv file, skip.");
                    continue;
                }
                Object[] values = recordInfo.readValues(record);
                csvPrinter.printRecord(values);
            }
            csvPrinter.flush();
        }
        catch (IOException e) {
            this.forceDeleteTempFile(outFile);
            throw new IllegalStateException("export csv error.", e);
        }
    }

    private void exportWithSpecSplit(Iterable<?> records, RecordInfo recordInfo, File outFile) {
        try (FileWriter fileWriter = new FileWriter(outFile);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            String headerStr = String.join((CharSequence)this.delimiter, recordInfo.getFieldTitles()) + LF;
            bufferedWriter.write(headerStr);
            for (Object record : records) {
                if ((record = this.dataHandle.handle(record, DataHandle.OperationType.EXPORT)) == null) {
                    logger.warn("return null value after custom handle while export csv file, skip.");
                    continue;
                }
                Object[] values = recordInfo.readValues(record);
                bufferedWriter.write(String.join((CharSequence)this.delimiter, (CharSequence[])Stream.of(values).map(String::valueOf).toArray(String[]::new)) + LF);
            }
            bufferedWriter.flush();
        }
        catch (IOException e) {
            this.forceDeleteTempFile(outFile);
            throw new IllegalStateException("export csv error.", e);
        }
    }

    private void forceDeleteTempFile(File outFile) {
        if (outFile.exists() && outFile.delete()) {
            logger.debug("File[{}] has delete success!", (Object)outFile.getAbsolutePath());
        }
    }

    public void importData(File file, Consumer<Object> consumer, Visitor<Object> visitor) {
        RecordInfo recordInfo = RecordInfo.of(this.headClass, this.headProperty.getNotIgnoreHeadInfos());
        String[] headArray = recordInfo.getFieldTitles();
        Visitor<Object> v = Optional.ofNullable(visitor).orElse(Visitor.NULL_VISITOR);
        if (this.delimiter.length() > 1) {
            this.importWithSpecSplit(recordInfo, headArray, file, consumer, v);
        } else {
            this.importWithSingleSplit(recordInfo, headArray, file, consumer, v);
        }
    }

    private void importWithSingleSplit(RecordInfo recordInfo, String[] headArray, File file, Consumer<Object> consumer, Visitor<Object> visitor) {
        CSVFormat format = COMMA.equals(this.delimiter) ? CSVFormat.EXCEL : CSVFormat.newFormat((char)this.delimiter.charAt(0)).withIgnoreEmptyLines().withRecordSeparator(LF);
        format = format.withHeader(headArray).withFirstRecordAsHeader().withIgnoreHeaderCase();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
             CSVParser csvParser = new CSVParser((Reader)reader, format);){
            for (CSVRecord record : csvParser) {
                HashMap<String, Object> recordMap = new HashMap<String, Object>(8);
                for (String head : headArray) {
                    recordMap.put(head, record.get(head));
                }
                visitor.visit(recordMap);
                Object bean = recordInfo.writeValues(this.headClass, recordMap);
                bean = this.dataHandle.handle(bean, DataHandle.OperationType.IMPORT);
                if (bean == null) {
                    logger.warn("return null value after custom handle while import csv file, skip.");
                    continue;
                }
                consumer.accept(bean);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("import csv file error. ", e);
        }
    }

    private void importWithSpecSplit(RecordInfo recordInfo, String[] headArray, File file, Consumer<Object> consumer, Visitor<Object> visitor) {
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line;
            String firstLine = bufferedReader.readLine();
            logger.debug("Has read first line is:{}", (Object)firstLine);
            while ((line = bufferedReader.readLine()) != null) {
                String[] recordArray = line.split(Pattern.quote(this.delimiter), headArray.length);
                HashMap<String, Object> recordMap = new HashMap<String, Object>(8);
                for (int i = 0; i < headArray.length; ++i) {
                    recordMap.put(headArray[i], recordArray[i]);
                }
                visitor.visit(recordMap);
                Object bean = recordInfo.writeValues(this.headClass, recordMap);
                bean = this.dataHandle.handle(bean, DataHandle.OperationType.IMPORT);
                if (bean == null) {
                    logger.warn("return null value after custom handle while import csv file, skip.");
                    continue;
                }
                consumer.accept(bean);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("import csv file error. ", e);
        }
    }
}

