/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.config;

import cn.com.yusys.yusp.commons.autoconfigure.document.excel.ExcelCsvAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.document.excel.ExcelProperties;
import cn.com.yusys.yusp.commons.excelcsv.ExcelAdapterUtils;
import cn.com.yusys.yusp.commons.excelcsv.ExcelUtils;
import cn.com.yusys.yusp.commons.excelcsv.async.AsyncPoolServiceExecutor;
import com.github.pagehelper.PageHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={ExcelCsvAutoConfiguration.class})
@EnableConfigurationProperties(value={ExcelProperties.class})
public class ExcelStarterAutoConfiguration {
    private final ExcelProperties excelProperties;
    public static final String EXCEL_CSV_EXECUTOR = "ExcelCsvExecutorService";

    public ExcelStarterAutoConfiguration(ExcelProperties excelProperties) {
        this.excelProperties = excelProperties;
    }

    @Autowired
    public void initExcelUtils(AsyncPoolServiceExecutor executor) {
        ExcelUtils.initiating(executor, this.excelProperties.getTempDir(), this.excelProperties.getBatchSize(), this.excelProperties.getSheetMaxRow());
    }

    @Configuration
    @ConditionalOnClass(value={PageHelper.class})
    @Deprecated
    static class ExcelAdapterAutoConfiguration {
        ExcelAdapterAutoConfiguration() {
        }

        @Autowired
        public void initExcelAdapterUtils(@Value(value="${yusp.excelcsv.batch-size:2000}") int batchSize, @Value(value="${yusp.excelcsv.page-size:2000}") int pageSize) {
            ExcelAdapterUtils.initiating(batchSize, pageSize);
        }
    }
}

