/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ribbon.zuul;

import org.springframework.boot.context.properties.ConfigurationPropertiesBindHandlerAdvisor;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;

public class ZuulPropertiesBindingHandlerAdvise
implements ConfigurationPropertiesBindHandlerAdvisor {
    private final ConfigurationPropertyName zuulDefaultPropertyName = ConfigurationPropertyName.of((CharSequence)"zuul.routes");
    private final ConfigurationPropertyName zuulDefaultStripPrefixName = ConfigurationPropertyName.of((CharSequence)"zuul");

    public BindHandler apply(final BindHandler bindHandler) {
        return new AbstractBindHandler(bindHandler){

            public <T> Bindable<T> onStart(ConfigurationPropertyName name, Bindable<T> target, BindContext context) {
                BindResult result;
                ConfigurationPropertyName defaultName = ZuulPropertiesBindingHandlerAdvise.this.getDefaultName(name);
                if (defaultName != null && (result = context.getBinder().bind(defaultName, target)).isBound()) {
                    return target.withExistingValue(result.get());
                }
                return bindHandler.onStart(name, target, context);
            }
        };
    }

    private ConfigurationPropertyName getDefaultName(ConfigurationPropertyName name) {
        if (this.zuulDefaultPropertyName.isAncestorOf(name) && this.zuulDefaultPropertyName.getNumberOfElements() == name.getNumberOfElements() - 1) {
            return this.zuulDefaultStripPrefixName;
        }
        return null;
    }
}

