/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ribbon.zuul;

import cn.com.yusys.yusp.commons.ribbon.RouteConfig;
import cn.com.yusys.yusp.commons.ribbon.config.ServiceMappingProperties;
import cn.com.yusys.yusp.commons.ribbon.util.RouteUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.lang.NonNull;

public class ZuulPropertiesBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ZuulPropertiesBeanPostProcessor.class);
    private final ServiceMappingProperties properties;

    public ZuulPropertiesBeanPostProcessor(ServiceMappingProperties properties) {
        this.properties = properties;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        if (bean instanceof ZuulProperties) {
            ZuulProperties zuulProperties = (ZuulProperties)bean;
            return this.enhance(zuulProperties);
        }
        return bean;
    }

    private ZuulProperties enhance(ZuulProperties zuulProperties) {
        log.debug("Init routes config.");
        Map routes = zuulProperties.getRoutes();
        if (CollectionUtils.isEmpty((Map)routes)) {
            return zuulProperties;
        }
        if (Objects.isNull(this.properties)) {
            return zuulProperties;
        }
        Map<String, RouteConfig> routeConfigMap = this.properties.getRoutes();
        if (CollectionUtils.isEmpty(routeConfigMap)) {
            return zuulProperties;
        }
        String globalPrefix = this.properties.getPathPrefix();
        routes.forEach((id, route) -> RouteUtils.initRoute(id, (RouteConfig)routeConfigMap.get(id), globalPrefix, (path, serviceId) -> {
            route.setPath(path);
            route.setServiceId(serviceId);
        }, (path, serviceId) -> {}));
        return zuulProperties;
    }
}

