/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ribbon;

import cn.com.yusys.yusp.commons.util.ObjectUtils;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeRule
extends ZoneAvoidanceRule {
    public static final String COMPOSITE_RULE_CONFIG = "compositeRuleConfig";
    private static final Logger log = LoggerFactory.getLogger(CompositeRule.class);
    private static final CompositeRuleConfigKey COMPOSITE_RULE_CONFIG_KEY = new CompositeRuleConfigKey();
    private final IRule defaultRule = new RoundRobinRule();
    private List<IRule> ruleList = Collections.singletonList(this.defaultRule);

    public static CompositeRuleConfigKey getInstance() {
        return COMPOSITE_RULE_CONFIG_KEY;
    }

    public void setRuleList(List<IRule> ruleList) {
        this.ruleList = ruleList;
    }

    public Server choose(Object key) {
        Server server = null;
        for (IRule rule : this.ruleList) {
            if (rule == null) continue;
            log.debug("exec route rule :{}", rule.getClass());
            try {
                server = rule.choose(key);
            }
            catch (Throwable e) {
                log.error("exec route rule:{} exception,cause by :{}", rule.getClass(), (Object)e.getMessage());
                continue;
            }
            if (server == null) {
                log.debug("current rule:{} cannot fetch a available server", rule.getClass());
                continue;
            }
            log.debug("current route rule :{} matched,fetch available server:{}", rule.getClass(), (Object)server.getHostPort());
            break;
        }
        if (server != null) {
            log.info("service[{}]-->location:{}", key, (Object)server.getHostPort());
        }
        return server;
    }

    public void setLoadBalancer(ILoadBalancer lb) {
        super.setLoadBalancer(lb);
        this.ruleList.forEach(rule -> rule.setLoadBalancer(lb));
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        CompositeRule configRule = (CompositeRule)((Object)clientConfig.get((IClientConfigKey)COMPOSITE_RULE_CONFIG_KEY));
        this.ruleList = Objects.isNull((Object)configRule) || ObjectUtils.isNullOrEmpty(configRule.ruleList) ? Collections.singletonList(this.defaultRule) : configRule.ruleList;
        super.initWithNiwsConfig(clientConfig);
    }

    static class CompositeRuleConfigKey
    implements IClientConfigKey<CompositeRule> {
        CompositeRuleConfigKey() {
        }

        public String key() {
            return CompositeRule.COMPOSITE_RULE_CONFIG;
        }

        public Class<CompositeRule> type() {
            return CompositeRule.class;
        }
    }
}

