/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.config;

import cn.com.yusys.yusp.commons.file.config.FileFilterProperties;
import cn.com.yusys.yusp.commons.file.web.filter.FileUploadCheckFilter;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={FileFilterProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class FileFilterAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(FileFilterAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(prefix="yusp.filter.file-upload", name={"enabled"})
    public FileUploadCheckFilter fileUploadCheckFilter(FileFilterProperties fileFilterProperties) {
        logger.info("Auto configuration >> prevent malicious file upload filter configuration completed");
        String[] accessFileTypeArray = StringUtils.split((String)fileFilterProperties.getAccessFileType(), (String)",");
        ArrayList<String> accessFileTypeList = new ArrayList<String>();
        Collections.addAll(accessFileTypeList, accessFileTypeArray);
        return new FileUploadCheckFilter(accessFileTypeList);
    }
}

