/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis.util;

import cn.com.yusys.yusp.commons.util.IdUtils;
import java.time.Duration;
import java.util.Objects;

public class RedisUtils {
    public static final String DURATION_TIME = "30S";
    public static final String EVICT_DURATION_TIME = "30S";
    public static final String DEFAULT_FOREVER_STR = "-1";

    private RedisUtils() {
    }

    public static Duration getDuration(String value) {
        Duration duration;
        if (Objects.isNull(value) || value.length() <= 1) {
            return null;
        }
        if (DEFAULT_FOREVER_STR.equals(value)) {
            Duration duration2 = Duration.ZERO;
            return duration2;
        }
        String timeunit = value.substring(value.length() - 1).toUpperCase();
        long time = Long.parseLong(value.substring(0, value.length() - 1));
        switch (timeunit) {
            case "D": {
                duration = Duration.ofDays(time);
                break;
            }
            case "H": {
                duration = Duration.ofHours(time);
                break;
            }
            case "M": {
                duration = Duration.ofMinutes(time);
                break;
            }
            case "S": {
                duration = Duration.ofSeconds(time);
                break;
            }
            case "L": {
                duration = Duration.ofMillis(time);
                break;
            }
            case "N": {
                duration = Duration.ofNanos(time);
                break;
            }
            default: {
                duration = Duration.ofSeconds(Long.parseLong(value));
            }
        }
        return duration;
    }

    public static String randomPrefix(String prefix) {
        return prefix + IdUtils.getId();
    }
}

