/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis.connection;

import cn.com.yusys.yusp.commons.exception.CustomizeRedisException;
import java.util.List;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisScriptReturnConverter;
import org.springframework.util.Assert;
import redis.clients.jedis.JedisCluster;

public class EnhanceJedisClusterScriptingCommands
implements RedisScriptingCommands {
    private static final String ERROR_DESC = "not supported in cluster environment.";
    private final JedisCluster jedisCluster;

    public EnhanceJedisClusterScriptingCommands(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    public void scriptFlush() {
        throw new InvalidDataAccessApiUsageException(ERROR_DESC);
    }

    public void scriptKill() {
        throw new InvalidDataAccessApiUsageException(ERROR_DESC);
    }

    public String scriptLoad(byte[] bytes) {
        throw new InvalidDataAccessApiUsageException(ERROR_DESC);
    }

    public List<Boolean> scriptExists(String ... strings) {
        throw new InvalidDataAccessApiUsageException(ERROR_DESC);
    }

    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)script, (String)"script must not be null");
        return (T)new JedisScriptReturnConverter(returnType).convert(this.jedisCluster.eval(script, JedisConverters.toBytes((Integer)numKeys), keysAndArgs));
    }

    public <T> T evalSha(String script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return this.evalSha(JedisConverters.toBytes((String)script), returnType, numKeys, keysAndArgs);
    }

    public <T> T evalSha(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)script, (String)"script must not be null");
        try {
            return (T)new JedisScriptReturnConverter(returnType).convert(this.jedisCluster.evalsha(script, numKeys, keysAndArgs));
        }
        catch (Exception e) {
            throw new CustomizeRedisException(e.getMessage(), e);
        }
    }
}

