/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.rpc.netcom.jetty.server;

import cn.com.yusys.yusp.commons.job.core.rpc.netcom.jetty.server.JettyServerHandler;
import cn.com.yusys.yusp.commons.job.core.thread.ExecutorRegistryThread;
import cn.com.yusys.yusp.commons.job.core.thread.TriggerCallbackThread;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer {
    private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);
    private Server server;
    private Thread thread;

    public void start(int port, String ip, String appName) {
        this.start(port, ip, appName, false, null);
    }

    public void start(int port, String ip, String appName, boolean verifyAccessToken, String accessToken) {
        this.thread = new Thread(() -> {
            this.server = new Server((ThreadPool)new ExecutorThreadPool());
            ServerConnector connector = new ServerConnector(this.server);
            if (ip != null && ip.trim().length() > 0) {
                connector.setHost(ip);
            }
            connector.setPort(port);
            this.server.setConnectors(new Connector[]{connector});
            HandlerCollection handlerc = new HandlerCollection();
            handlerc.setHandlers(new Handler[]{new JettyServerHandler(verifyAccessToken, accessToken)});
            this.server.setHandler((Handler)handlerc);
            try {
                this.server.start();
                logger.info(">>>>>>>>>>> job jetty server start success at port:{}.", (Object)port);
                ExecutorRegistryThread.getInstance().start(port, ip, appName);
                TriggerCallbackThread.getInstance().start();
                this.server.join();
                logger.info(">>>>>>>>>>> rpc server join success, netcon={}, port={}", (Object)JettyServer.class.getName(), (Object)port);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void destroy() {
        ExecutorRegistryThread.getInstance().toStop();
        TriggerCallbackThread.getInstance().toStop();
        if (this.server != null) {
            try {
                this.server.stop();
                this.server.destroy();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.thread.isAlive()) {
            this.thread.interrupt();
        }
        logger.info(">>>>>>>>>>> rpc server destroy success, netcon={}", (Object)JettyServer.class.getName());
    }
}

