/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.handler.impl;

import cn.com.yusys.yusp.commons.job.core.biz.model.ReturnT;
import cn.com.yusys.yusp.commons.job.core.glue.GlueTypeEnum;
import cn.com.yusys.yusp.commons.job.core.handler.IJobHandler;
import cn.com.yusys.yusp.commons.job.core.log.JobFileAppender;
import cn.com.yusys.yusp.commons.job.core.log.JobLogger;
import cn.com.yusys.yusp.commons.job.core.util.ScriptUtil;
import cn.com.yusys.yusp.commons.job.core.util.ShardingUtil;

public class ScriptJobHandler
extends IJobHandler {
    private String jobId;
    private long glueUpdatetime;
    private String gluesource;
    private GlueTypeEnum glueType;

    public ScriptJobHandler(String jobId, long glueUpdatetime, String gluesource, GlueTypeEnum glueType) {
        this.jobId = jobId;
        this.glueUpdatetime = glueUpdatetime;
        this.gluesource = gluesource;
        this.glueType = glueType;
    }

    public long getGlueUpdatetime() {
        return this.glueUpdatetime;
    }

    @Override
    public ReturnT<String> execute(String param) throws Exception {
        if (!this.glueType.isScript()) {
            return new ReturnT<String>(IJobHandler.FAIL.getCode(), "glueType[" + (Object)((Object)this.glueType) + "] invalid.");
        }
        String cmd = this.glueType.getCmd();
        String scriptFileName = JobFileAppender.getGlueSrcPath().concat("/").concat(String.valueOf(this.jobId)).concat("_").concat(String.valueOf(this.glueUpdatetime)).concat(this.glueType.getSuffix());
        ScriptUtil.markScriptFile(scriptFileName, this.gluesource);
        String logFileName = (String)JobFileAppender.contextHolder.get();
        ShardingUtil.ShardingVO shardingVO = ShardingUtil.getShardingVo();
        String[] scriptParams = new String[]{param, String.valueOf(shardingVO.getIndex()), String.valueOf(shardingVO.getTotal())};
        JobLogger.log("----------- script file:" + scriptFileName + " -----------", new Object[0]);
        int exitValue = ScriptUtil.execToFile(cmd, scriptFileName, logFileName, scriptParams);
        ReturnT result = exitValue == 0 ? IJobHandler.SUCCESS : new ReturnT(IJobHandler.FAIL.getCode(), "script exit value(" + exitValue + ") is failed");
        return result;
    }
}

