/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.openfeign.mock.web;

import cn.com.yusys.yusp.commons.module.adapter.web.rest.ResultDto;
import cn.com.yusys.yusp.commons.openfeign.mock.store.MockData;
import cn.com.yusys.yusp.commons.openfeign.mock.store.MockDataStore;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"/api/mocks"})
public class MockDataController {
    private Logger logger = LoggerFactory.getLogger(MockDataController.class);
    private MockDataStore mockDataStore;

    public MockDataController(MockDataStore mockDataStore) {
        this.mockDataStore = mockDataStore;
    }

    @PostMapping(value={"/"})
    public ResultDto<Integer> storeMockData(@RequestBody List<MockData<?>> mockDataList) {
        this.logger.debug("\u6279\u91cf\u5b58\u50a8mock\u6570\u636e:{}", mockDataList);
        return ResultDto.success((Object)this.mockDataStore.store(mockDataList));
    }

    @DeleteMapping(value={"/"})
    public ResultDto<Integer> clearMocks(@RequestBody List<String> urlList) {
        this.logger.debug("\u79fb\u9664mock\u6570\u636e:{}", urlList);
        return ResultDto.success((Object)this.mockDataStore.deleteMocks(urlList));
    }

    @DeleteMapping(value={"/all"})
    public ResultDto<Integer> clearMocksAll() {
        this.logger.debug("\u79fb\u9664\u6240\u6709mock\u6570\u636e");
        return ResultDto.success((Object)this.mockDataStore.deleteAll());
    }
}

