/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.util;

import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class FilePathUtils
extends FilenameUtils {
    public static final char UNIX_SEPARATOR_CHAR = '/';
    public static final String UNIX_SEPARATOR = "/";
    private static final Pattern SEPARATOR_CHAR_PATTERN = Pattern.compile("\\\\|\\\\\\\\");

    public static String concatRelativePath(String basePath, String relativePath) {
        if (relativePath == null) {
            return basePath;
        }
        String appendPath = relativePath;
        int prefix = FilePathUtils.getPrefixLength((String)appendPath);
        if (prefix < 0) {
            return null;
        }
        if (prefix > 0) {
            appendPath = appendPath.substring(prefix);
        }
        if (basePath == null) {
            return relativePath;
        }
        int len = basePath.length();
        if (len == 0) {
            return FilePathUtils.normalize((String)appendPath);
        }
        char ch = basePath.charAt(len - 1);
        if (ch == '/') {
            return FilePathUtils.normalize((String)(basePath + appendPath));
        }
        return FilePathUtils.normalize((String)(basePath + UNIX_SEPARATOR + appendPath));
    }

    public static String concatFileName(String path, String fileName) {
        if (path == null) {
            return fileName;
        }
        char ch = path.charAt(path.length() - 1);
        if (ch == '/') {
            return path + fileName;
        }
        return path + UNIX_SEPARATOR + fileName;
    }

    public static String getAbsolutePath(String filepath, String fileName) {
        return FilePathUtils.getAbsolutePath(filepath, fileName, true);
    }

    public static String getAbsolutePath(String filepath, String fileName, boolean useUnixSeparator) {
        return FilePathUtils.getAbsolutePath(filepath, fileName, useUnixSeparator ? (char)'/' : '\\');
    }

    public static String getAbsolutePath(String filepath, String fileName, String separator) {
        String file = StringUtils.builder0((Object[])new Object[]{FilePathUtils.getFullPath((String)new File(StringUtils.builder0((Object[])new Object[]{filepath, separator, fileName})).getPath()), fileName});
        return FilePathUtils.pathEscape(file);
    }

    public static String getAbsolutePath(String filepath, String fileName, char separator) {
        return FilePathUtils.getAbsolutePath(filepath, fileName, Character.toString(separator));
    }

    public static String pathEscape(String path) {
        Matcher matcher;
        if (StringUtils.nonEmpty((CharSequence)path) && (matcher = SEPARATOR_CHAR_PATTERN.matcher(path)).find()) {
            return matcher.replaceAll(UNIX_SEPARATOR);
        }
        return path;
    }
}

